/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.gui.styling.ILibraryModel;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryBrowser
extends JPanel
implements TreeModelListener {
    private static final long serialVersionUID = 4322139976928871347L;
    private static final Logger logger = LoggerFactory.getLogger(LibraryBrowser.class);
    private ILibraryModel model;
    private JTree tree;
    private JPopupMenu popUpMenu;
    private JMenuItem newFolder;
    private JMenuItem removeFolder;
    private ActionListener popUpMenuActions = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedObject = LibraryBrowser.this.tree.getLastSelectedPathComponent();
            Object source = e.getSource();
            LibraryBrowser.this.removeFolder.setEnabled(selectedObject != null);
            try {
                if (source.equals(LibraryBrowser.this.newFolder)) {
                    String newFolderName = JOptionPane.showInputDialog(Messages.getText((String)"new_name"));
                    if (newFolderName != null) {
                        LibraryBrowser.this.model.addFolder(selectedObject, newFolderName);
                    }
                } else if (source.equals(LibraryBrowser.this.removeFolder)) {
                    LibraryBrowser.this.model.removeFolder(selectedObject);
                }
            }
            catch (Exception ex) {
                logger.error(Messages.getText((String)("notification_text [" + new Date(System.currentTimeMillis()).toString() + "]")), (Throwable)ex);
            }
            finally {
                LibraryBrowser.this.popUpMenu.setVisible(false);
            }
        }
    };
    private ArrayList<TreeSelectionListener> treeListeners = new ArrayList();
    private ArrayList<MouseListener> treeMouseListeners = new ArrayList();
    private ArrayList<MouseMotionListener> treeMouseMotionListeners = new ArrayList();

    public LibraryBrowser(ILibraryModel model) {
        this.setLayout(new BorderLayout());
        model.addTreeModelListener(this);
        this.popUpMenu = new JPopupMenu();
        this.newFolder = new JMenuItem(Messages.getText((String)"new_folder"));
        this.newFolder.addActionListener(this.popUpMenuActions);
        this.removeFolder = new JMenuItem(Messages.getText((String)"remove_folder"));
        this.removeFolder.addActionListener(this.popUpMenuActions);
        this.popUpMenu.add(this.newFolder);
        this.model = model;
        this.setModel(model);
    }

    private ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    private void setModel(ILibraryModel model) {
        int i;
        if (this.tree != null) {
            this.remove(this.tree);
        }
        this.tree = new JTree();
        this.tree.setModel(model);
        for (i = 0; i < this.treeListeners.size(); ++i) {
            this.tree.addTreeSelectionListener(this.treeListeners.get(i));
        }
        for (i = 0; i < this.treeMouseListeners.size(); ++i) {
            this.tree.addMouseListener(this.treeMouseListeners.get(i));
        }
        for (i = 0; i < this.treeMouseMotionListeners.size(); ++i) {
            this.tree.addMouseMotionListener(this.treeMouseMotionListeners.get(i));
        }
        ImageIcon folderIcon = IconThemeHelper.getImageIcon((String)"librarybrowser-folder");
        ImageIcon leafIcon = IconThemeHelper.getImageIcon((String)"librarybrowser-folder-image");
        if (leafIcon != null && folderIcon != null) {
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setLeafIcon(leafIcon);
            renderer.setOpenIcon(folderIcon);
            renderer.setClosedIcon(folderIcon);
            this.tree.setCellRenderer(renderer);
        }
        this.add((Component)this.tree, "Center");
        this.validate();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            Point p = new Point();
            p.x = this.getLocationOnScreen().x + e.getPoint().x;
            p.y = this.getLocationOnScreen().y + e.getPoint().y;
            this.popUpMenu.setLocation(p);
            this.popUpMenu.setVisible(true);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.refresh();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.refresh();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.refresh();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.refresh();
    }

    public Object getLastSelectedPathComponent() {
        return this.tree.getLastSelectedPathComponent();
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.treeListeners.add(treeSelectionListener);
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.treeMouseListeners.add(l);
        this.tree.addMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.treeMouseMotionListeners.add(l);
        this.tree.addMouseMotionListener(l);
    }

    public void setSelectionRow(int i) {
        this.tree.setSelectionRow(i);
    }

    public File getElementBellow(Point point) {
        TreePath tp = this.tree.getPathForLocation(point.x, point.y);
        if (tp == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof File) {
            return (File)node.getUserObject();
        }
        return null;
    }

    public void setSelectedElementBellow(Point point) {
        TreePath tp = this.tree.getPathForLocation(point.x, point.y);
        if (tp != null) {
            this.tree.setSelectionPath(tp);
        }
    }

    public void refresh() {
        this.setModel(this.model);
    }
}

