/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.gui.styling.SymbolSelectorBrowser;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.IMultiShapeSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiShapeSymbolSelector
extends JPanel
implements ISymbolSelector,
ActionListener {
    private static Logger logger = LoggerFactory.getLogger(MultiShapeSymbolSelector.class);
    private static final long serialVersionUID = 3967550608736418084L;
    private SymbolSelector markerSelector;
    private SymbolSelector lineSelector;
    private SymbolSelector fillSelector;
    private WindowInfo wi;
    private JTabbedPane tabbedPane;
    private GeometryManager gManager = null;
    private JButton closeButton = null;
    private JPanel closeButtonPanel = null;
    private FeatureStore featureStore;

    public static ISymbolSelector createSymbolBrowser() {
        WindowInfo winfo = new WindowInfo(7);
        winfo.setWidth(706);
        winfo.setHeight(500);
        winfo.setTitle(Messages.getText((String)"symbols_browser"));
        MultiShapeSymbolSelector resp = null;
        try {
            resp = new MultiShapeSymbolSelector();
            resp.wi = winfo;
        }
        catch (BaseException e) {
            logger.info("Unable to create symbol browser, will use selector.", (Throwable)e);
            resp = new MultiShapeSymbolSelector(winfo);
        }
        return resp;
    }

    private MultiShapeSymbolSelector() throws BaseException {
        GeometryType gt = this.getGeomManager().getGeometryType(1, 0);
        this.markerSelector = new SymbolSelectorBrowser(gt, true);
        gt = this.getGeomManager().getGeometryType(2, 0);
        this.lineSelector = new SymbolSelectorBrowser(gt, true);
        gt = this.getGeomManager().getGeometryType(3, 0);
        this.fillSelector = new SymbolSelectorBrowser(gt, true);
        this.initialize(true);
    }

    private MultiShapeSymbolSelector(WindowInfo wi) {
        this((Object)null);
        this.wi = wi;
    }

    MultiShapeSymbolSelector(Object currSymbol) {
        IMultiShapeSymbol sym = null;
        try {
            sym = (IMultiShapeSymbol)currSymbol;
        }
        catch (Exception ex) {
            logger.warn("Incorrect symbol type, use default.", (Throwable)ex);
        }
        if (sym == null) {
            this.markerSelector = (SymbolSelector)SymbolSelector.createSymbolSelector(null, 1);
            this.lineSelector = (SymbolSelector)SymbolSelector.createSymbolSelector(null, 2);
            this.fillSelector = (SymbolSelector)SymbolSelector.createSymbolSelector(null, 3);
        } else {
            this.markerSelector = (SymbolSelector)SymbolSelector.createSymbolSelector(sym.getMarkerSymbol(), 1);
            this.lineSelector = (SymbolSelector)SymbolSelector.createSymbolSelector(sym.getLineSymbol(), 2);
            this.fillSelector = (SymbolSelector)SymbolSelector.createSymbolSelector(sym.getFillSymbol(), 3);
        }
        this.initialize(false);
    }

    private void initialize(boolean add_close_button) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJTabbedPane(), "Center");
        if (add_close_button) {
            this.add(this.getCloseButtonPanel(), "South");
        }
    }

    private JTabbedPane getJTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab(Messages.getText((String)"marker"), this.markerSelector);
            this.tabbedPane.addTab(Messages.getText((String)"line"), this.lineSelector);
            this.tabbedPane.addTab(Messages.getText((String)"fill"), this.fillSelector);
            this.tabbedPane.setPreferredSize(this.getWindowInfo().getMinimumSize());
        }
        return this.tabbedPane;
    }

    @Override
    public Object getSelectedObject() {
        IMultiShapeSymbol sym = SymbologyLocator.getSymbologyManager().createMultiShapeSymbol();
        IMarkerSymbol ims = (IMarkerSymbol)this.markerSelector.getSelectedObject();
        ILineSymbol ils = (ILineSymbol)this.lineSelector.getSelectedObject();
        IFillSymbol ifs = (IFillSymbol)this.fillSelector.getSelectedObject();
        if (ims == null || ils == null || ifs == null) {
            return null;
        }
        sym.setMarkerSymbol(ims);
        sym.setLineSymbol(ils);
        sym.setFillSymbol(ifs);
        return sym;
    }

    @Override
    public void setSymbol(Object symbol) {
        IMultiShapeSymbol sym = (IMultiShapeSymbol)symbol;
        this.markerSelector.setSymbol(sym.getMarkerSymbol());
        this.lineSelector.setSymbol(sym.getLineSymbol());
        this.fillSelector.setSymbol(sym.getFillSymbol());
    }

    public WindowInfo getWindowInfo() {
        if (this.wi == null) {
            this.wi = new WindowInfo(9);
            this.wi.setWidth(706);
            this.wi.setHeight(500);
            this.wi.setTitle(Messages.getText((String)"symbol_selector"));
        }
        return this.wi;
    }

    public Object getWindowProfile() {
        if (this.wi.isModal()) {
            return WindowInfo.DIALOG_PROFILE;
        }
        return WindowInfo.EDITOR_PROFILE;
    }

    private GeometryManager getGeomManager() {
        if (this.gManager == null) {
            this.gManager = GeometryLocator.getGeometryManager();
        }
        return this.gManager;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            String txt = Messages.getText((String)"close");
            this.closeButton = new JButton(txt);
            this.closeButton.addActionListener(this);
        }
        return this.closeButton;
    }

    private Component getCloseButtonPanel() {
        if (this.closeButtonPanel == null) {
            this.closeButtonPanel = new JPanel();
            Border brd = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            this.closeButtonPanel.setBorder(brd);
            this.closeButtonPanel.setLayout(new BorderLayout());
            this.closeButtonPanel.add((Component)this.getCloseButton(), "East");
        }
        return this.closeButtonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getCloseButton()) {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
    }

    @Override
    public void setFeatureStore(FeatureStore store) {
        this.featureStore = store;
    }
}

