/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.app.project.documents.view.legend.gui.JSymbolPreviewButton;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.ISimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFill
extends AbstractTypeSymbolEditor
implements ActionListener,
ChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFill.class);
    private ColorChooserPanel jccFillColor;
    private JNumberSpinner txtOutlineWidth;
    private ArrayList tabs = new ArrayList();
    private JSymbolPreviewButton btnOutline;
    private JSlider sldOutlineTransparency;
    private int outlineAlpha;
    private ILineSymbol outline;
    private JCheckBox useBorder;

    public SimpleFill(SymbolEditor owner) {
        super(owner);
        this.initialize();
    }

    @Override
    public String getName() {
        return Messages.getText((String)"simple_fill_symbol");
    }

    @Override
    public JPanel[] getTabs() {
        return this.tabs.toArray(new JPanel[0]);
    }

    private void initialize() {
        JPanel myTab = new JPanel(new FlowLayout(3, 5, 5));
        myTab.setName(Messages.getText((String)"simple_fill"));
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        this.jccFillColor = new ColorChooserPanel(true, true);
        this.jccFillColor.setAlpha(255);
        aux.addComponent(Messages.getText((String)"fill_color"), (Component)this.jccFillColor);
        JPanel aux2 = new JPanel();
        this.btnOutline = new JSymbolPreviewButton(2);
        this.btnOutline.setPreferredSize(new Dimension(100, 35));
        aux2.add(this.btnOutline);
        aux.addComponent((Component)new JBlank(10, 10));
        this.useBorder = new JCheckBox(Messages.getText((String)"use_outline"));
        aux.addComponent((Component)this.useBorder, (Component)aux2);
        aux.addComponent((Component)new JBlank(10, 10));
        this.sldOutlineTransparency = new JSlider();
        this.sldOutlineTransparency.setValue(100);
        aux.addComponent(Messages.getText((String)"outline") + ":", (Component)aux2);
        aux.addComponent(Messages.getText((String)"outline_opacity"), (Component)this.sldOutlineTransparency);
        this.txtOutlineWidth = new JNumberSpinner(0.0, 25, 0.0, Double.MAX_VALUE, 1.0, 2);
        aux.addComponent(Messages.getText((String)"outline_width"), (Component)this.txtOutlineWidth);
        myTab.add((Component)aux);
        this.useBorder.addActionListener(this);
        this.jccFillColor.addActionListener((ActionListener)this);
        this.btnOutline.addActionListener(this);
        this.txtOutlineWidth.addActionListener((ActionListener)this);
        this.sldOutlineTransparency.addChangeListener(this);
        this.tabs.add(myTab);
    }

    @Override
    public ISymbol getLayer() {
        ISimpleFillSymbol layer = SymbologyLocator.getSymbologyManager().createSimpleFillSymbol();
        layer.setHasOutline(this.useBorder.isSelected());
        this.outline = (ILineSymbol)this.btnOutline.getSymbol();
        if (this.outline != null) {
            this.outline.setLineWidth(this.txtOutlineWidth.getDouble());
            this.outline.setAlpha(this.outlineAlpha);
        }
        layer.setOutline(this.outline);
        layer.setHasFill(this.jccFillColor.getUseColorisSelected());
        Color c = this.jccFillColor.getColor();
        if (c != null) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        layer.setFillColor(c);
        return layer;
    }

    @Override
    public void refreshControls(ISymbol layer) {
        try {
            if (layer == null) {
                LOG.warn(this.getClass().getName() + ":: should be unreachable code", (Throwable)new Exception());
            } else {
                IFillSymbol sym = (IFillSymbol)layer;
                this.jccFillColor.setUseColorIsSelected(sym.hasFill());
                this.jccFillColor.setColor(sym.getFillColor());
                this.sldOutlineTransparency.removeChangeListener(this);
                this.outline = sym.getOutline();
                this.btnOutline.setSymbol((ISymbol)this.outline);
                this.useBorder.setSelected(sym.hasOutline());
                if (this.outline != null) {
                    this.outlineAlpha = this.outline.getAlpha();
                    this.sldOutlineTransparency.setValue((int)((double)this.outlineAlpha / 255.0 * 100.0));
                    this.txtOutlineWidth.setDouble(this.outline.getLineWidth());
                } else {
                    this.sldOutlineTransparency.setValue(100);
                }
                this.sldOutlineTransparency.addChangeListener(this);
            }
        }
        catch (IndexOutOfBoundsException ioEx) {
            LOG.warn("Symbol layer index out of bounds", (Throwable)ioEx);
        }
        catch (ClassCastException ccEx) {
            LOG.warn("Illegal casting from " + layer.getClass().getName() + " to IFillSymbol.", (Throwable)ccEx);
        }
    }

    @Override
    public boolean canManageSymbol(ISymbol symbol) {
        return symbol instanceof ISimpleFillSymbol;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ILineSymbol outline;
        ISymbol sym;
        Object s = e.getSource();
        if (s.equals(this.btnOutline) && (sym = this.btnOutline.getSymbol()) instanceof ILineSymbol && (outline = (ILineSymbol)sym) != null) {
            this.txtOutlineWidth.setDouble(outline.getLineWidth());
        }
        this.fireSymbolChangedEvent();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object s = e.getSource();
        if (s.equals(this.sldOutlineTransparency)) {
            this.outlineAlpha = (int)(255.0 * ((double)this.sldOutlineTransparency.getValue() / 100.0));
        }
        this.outline = (ILineSymbol)this.btnOutline.getSymbol();
        this.fireSymbolChangedEvent();
    }

    @Override
    public EditorTool[] getEditorTools() {
        return null;
    }
}

