/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.event.ListDataListener;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.gui.styling.SelectorFilter;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.utils.listManager.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleSelectorListModel
implements ListModel {
    private static Logger logger = LoggerFactory.getLogger(StyleSelectorListModel.class);
    public static final String STYLE_FILE_EXTENSION = ".gvssty";
    protected Vector<IStyle> elements = null;
    protected File folder = null;
    protected FileFilter fFilter = null;
    protected SelectorFilter sFilter = null;
    protected String fileExt = "";

    public StyleSelectorListModel(File dir, SelectorFilter filter, String fileExtension) {
        this.fileExt = fileExtension.toLowerCase();
        this.folder = dir;
        this.sFilter = filter;
        this.fFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isFile()) {
                    return false;
                }
                return pathname.getAbsolutePath().toLowerCase().endsWith(StyleSelectorListModel.this.fileExt);
            }
        };
    }

    public Vector<IStyle> getObjects() {
        if (this.elements == null) {
            this.elements = new Vector();
            File[] ff = this.folder.listFiles(this.fFilter);
            for (int i = 0; i < ff.length; ++i) {
                try {
                    IStyle sty = this.loadStyle(ff[i]);
                    if (!this.sFilter.accepts(sty)) continue;
                    this.add(sty);
                    continue;
                }
                catch (Exception e) {
                    NotificationManager.addWarning((String)("Error in file [" + ff[i].getAbsolutePath() + "]. "), (Throwable)e);
                }
            }
        }
        return this.elements;
    }

    public void add(Object o) {
        TreeSet<Object> map = new TreeSet<Object>(new Comparator(){

            public int compare(Object o1, Object o2) {
                IStyle sym1 = (IStyle)o1;
                IStyle sym2 = (IStyle)o2;
                if (sym1.getDescription() == null && sym2.getDescription() != null) {
                    return -1;
                }
                if (sym1.getDescription() != null && sym2.getDescription() == null) {
                    return 1;
                }
                if (sym1.getDescription() == null && sym2.getDescription() == null) {
                    return 1;
                }
                int result = sym1.getDescription().compareTo(sym2.getDescription());
                return result != 0 ? result : 1;
            }
        });
        map.addAll(this.elements);
        map.add(o);
        this.elements = new Vector(map);
    }

    public int getSize() {
        return this.getObjects().size();
    }

    public Object getElementAt(int index) {
        return this.getObjects().get(index);
    }

    public void addListDataListener(ListDataListener l) {
    }

    public void removeListDataListener(ListDataListener l) {
    }

    public Object remove(int i) throws ArrayIndexOutOfBoundsException {
        return this.elements.remove(i);
    }

    public void insertAt(int i, Object o) {
        this.getObjects().insertElementAt((IStyle)o, i);
    }

    private IStyle loadStyle(File file) throws Exception {
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            PersistentState state = persistenceManager.loadState((InputStream)fis);
            IStyle sty = (IStyle)persistenceManager.create(state);
            fis.close();
            return sty;
        }
        return null;
    }
}

