/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolPreviewer
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SymbolPreviewer.class);
    private static final long serialVersionUID = 8095930506630873031L;
    private int hGap = 3;
    private int vGap = 3;
    private ISymbol symbol;
    private EditorTool prevTool;
    private boolean useAllRoom = false;
    private MutableObject<Feature> sampleFeature;

    public SymbolPreviewer(MutableObject<Feature> sampleFeature) {
        super(true);
        this.setBackground(Color.WHITE);
        this.sampleFeature = sampleFeature;
    }

    public SymbolPreviewer(MutableObject<Feature> sampleFeature, boolean all_room) {
        this(sampleFeature);
        this.useAllRoom = all_room;
    }

    public SymbolPreviewer(boolean all_room) {
        this((MutableObject<Feature>)new MutableObject(null), all_room);
    }

    public SymbolPreviewer() {
        this((MutableObject<Feature>)new MutableObject(null));
    }

    public ISymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(ISymbol symbol) {
        this.symbol = symbol;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints old = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.translate(this.hGap, this.vGap);
            Rectangle r = this.getBounds();
            r = new Rectangle(0, 0, (int)(r.getWidth() - (double)(this.hGap * 2)), (int)(r.getHeight() - (double)(this.vGap * 2)));
            Double forcesize = this.forceSize(this.symbol);
            if (forcesize != null && !this.useAllRoom) {
                long difx = Math.round(0.5 * (r.getWidth() - forcesize));
                long dify = Math.round(0.5 * (r.getHeight() - forcesize));
                r = new Rectangle((int)difx, (int)dify, (int)forcesize.doubleValue(), (int)forcesize.doubleValue());
            }
            if (this.symbol != null) {
                try {
                    if (this.symbol instanceof ISymbol_v2) {
                        ((ISymbol_v2)this.symbol).setFeature((Feature)this.sampleFeature.getValue());
                    }
                    this.symbol.drawInsideRectangle(g2, new AffineTransform(), r);
                }
                catch (SymbolDrawingException e) {
                    if (e.getType() == 0) {
                        try {
                            IWarningSymbol warnsym = MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, "", 0);
                            warnsym.drawInsideRectangle(g2, null, r);
                        }
                        catch (SymbolDrawingException warnsym) {}
                    }
                    throw new RuntimeException(Messages.getText((String)"symbol_shapetype_mismatch"), e);
                }
            } else {
                String noneSelected = "[" + Messages.getText((String)"preview_not_available") + "]";
                FontMetrics fm = g2.getFontMetrics();
                int lineWidth = fm.stringWidth(noneSelected);
                float scale = (float)r.getWidth() / (float)lineWidth;
                Font f = g2.getFont();
                float fontSize = (float)f.getSize() * scale;
                g2.setFont(f.deriveFont(fontSize));
                g2.drawString(noneSelected, (float)r.x * scale - (float)(this.hGap / 2), (float)(r.height / 2) + (float)this.vGap * scale);
            }
            g2.setRenderingHints(old);
        }
        catch (Throwable t) {
            LOGGER.warn("Can't preview symbol", t);
        }
    }

    public EditorTool setEditorTool(EditorTool tool) {
        MouseMotionListener[] mml;
        MouseListener[] ml;
        EditorTool previous = this.prevTool;
        for (MouseListener ml1 : ml = this.getMouseListeners()) {
            super.removeMouseListener(ml1);
        }
        for (MouseMotionListener mml1 : mml = this.getMouseMotionListeners()) {
            super.removeMouseMotionListener(mml1);
        }
        if (tool != null) {
            super.addMouseListener(tool);
            this.setCursor(tool.getCursor());
            super.addMouseMotionListener(tool);
        }
        this.prevTool = tool;
        return previous;
    }

    private Double forceSize(ISymbol sym) {
        if (sym == null) {
            return null;
        }
        if (!(sym instanceof IMarkerSymbol)) {
            return null;
        }
        IMarkerSymbol msym = (IMarkerSymbol)sym;
        if (msym.getUnit() == -1) {
            if (msym instanceof IMarkerSymbol_v2) {
                return ((IMarkerSymbol_v2)msym).getEfectiveSize((Feature)this.sampleFeature.getValue());
            }
            return msym.getSize();
        }
        return null;
    }
}

