/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.gvsig.app.gui.styling.SelectorFilter;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.gvsig.utils.listManager.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolSelectorListModel
extends AbstractListModel
implements ListModel,
Disposable {
    private static Logger logger = LoggerFactory.getLogger(SymbolSelectorListModel.class);
    private String fileExtension;
    private SelectorFilter sfilter;
    private Vector<ISymbol> elements;
    private File folder;
    private CancellableTask symbolLoader = null;

    public SymbolSelectorListModel(File dir, SelectorFilter filter, String fileExtension) {
        this.fileExtension = fileExtension;
        this.folder = dir;
        this.sfilter = filter;
    }

    public synchronized void dispose() {
        if (this.symbolLoader != null) {
            this.symbolLoader.cancelRequest();
        }
    }

    public Object remove(int i) throws ArrayIndexOutOfBoundsException {
        ISymbol o = this.elements.remove(i);
        this.fireIntervalRemoved(this, i, i);
        return o;
    }

    public void insertAt(int i, Object o) {
        this.getObjects().insertElementAt((ISymbol)o, i);
        this.fireIntervalAdded(this, i, i);
    }

    protected boolean accepts(ISymbol symbol) {
        if (this.sfilter == null) {
            return true;
        }
        return this.sfilter.accepts(symbol);
    }

    public void add(Object o) {
        ISymbol symbol = (ISymbol)o;
        if (!this.accepts(symbol)) {
            return;
        }
        Vector<ISymbol> e = this.getObjects();
        e.add((ISymbol)o);
        try {
            int n = e.size();
            this.fireIntervalAdded(this, n - 1, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector<ISymbol> getObjects() {
        if (this.elements == null) {
            this.elements = new Vector(0);
            FileFilter fileFiler = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().toLowerCase().endsWith(SymbolSelectorListModel.this.fileExtension);
                }
            };
            Visitor visitor = new Visitor(){

                public void visit(final Object obj) throws VisitCanceledException, BaseException {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SymbolSelectorListModel.this.add(obj);
                        }
                    });
                }
            };
            if (this.symbolLoader != null) {
                this.symbolLoader.cancelRequest();
            }
            this.symbolLoader = MapContextLocator.getSymbolManager().loadSymbols(this.folder, fileFiler, visitor);
        }
        return this.elements;
    }

    @Override
    public int getSize() {
        return this.getObjects().size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.getObjects().get(index);
    }
}

