/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.FeatureTablePanel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureStoreModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTypeList;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.SelectedFeatureTypeChangeListener;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTypesTablePanel
extends JPanel
implements SelectedFeatureTypeChangeListener {
    private static final long serialVersionUID = 5857146295213412304L;
    private static final Logger LOG = LoggerFactory.getLogger(FeatureTypesTablePanel.class);
    private FeatureTablePanel tablePanel;
    private FeatureTypeList typesControl;
    private JSplitPane jSplitPane = null;
    private FeatureStoreModel model;

    public FeatureTypesTablePanel(FeatureStore featureStore) throws BaseException {
        this(featureStore, true);
    }

    public FeatureTypesTablePanel(FeatureStore featureStore, boolean isDoubleBuffered) throws BaseException {
        this(featureStore, null, isDoubleBuffered);
    }

    public FeatureTypesTablePanel(FeatureStore featureStore, FeatureQuery featureQuery) throws BaseException {
        this(featureStore, featureQuery, true);
    }

    public FeatureTypesTablePanel(FeatureStore featureStore, FeatureQuery featureQuery, boolean isDoubleBuffered) throws BaseException {
        this(new FeatureStoreModel(featureStore, featureQuery), isDoubleBuffered);
    }

    public FeatureTypesTablePanel(FeatureStoreModel model) throws DataException {
        this(model, true);
    }

    public FeatureTypesTablePanel(FeatureStoreModel model, boolean isDoubleBuffered) throws DataException {
        super(isDoubleBuffered);
        this.model = model;
        this.typesControl = new FeatureTypeList(model.getFeatureStore(), model.getFeatureQuery());
        this.initializeUI();
        this.typesControl.addSelectedFeatureTypeChangeListener(this);
    }

    private boolean hasManyFeatureTypes() throws DataException {
        UnmodifiableBasicMap children = this.model.getFeatureStore().getChildren();
        if (!children.isEmpty()) {
            return true;
        }
        return this.typesControl.getFeatureTypesSize() > 1;
    }

    public JPanel createConfigurationPanel() {
        return this.tablePanel.createConfigurationPanel();
    }

    @Override
    public void change(FeatureStore featureStore, FeatureType featureType) {
        if (featureType != null) {
            this.showFeatureTypeData(featureType);
        }
    }

    private void showFeatureTypeData(FeatureType featureType) {
        this.showFeatureTypeData(featureType.getId());
    }

    private void showFeatureTypeData(String typeId) {
        this.model.setCurrentFeatureTypeId(typeId);
        try {
            this.tablePanel = new FeatureTablePanel(this.model.getCurrentFeatureTableModel());
        }
        catch (BaseException e) {
            throw new RuntimeException("Error creating a new FeatureTablePanel to show the selected FeatureType with id: " + typeId, e);
        }
        this.getJSplitPane().setRightComponent(this.tablePanel);
    }

    public FeatureTablePanel getTablePanel() {
        return this.tablePanel;
    }

    public FeatureTypeList getTypesControl() {
        return this.typesControl;
    }

    public void setSelectionUp(boolean selectionUp) {
        this.getTablePanel().setSelectionUp(selectionUp);
    }

    protected ConfigurableFeatureTableModel getTableModel() {
        return this.getTablePanel().getTableModel();
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(331, 251));
        this.add((Component)this.getJSplitPane(), "Center");
        this.showFeatureTypeData(this.model.getCurrentFeatureTypeId());
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane(1);
            JSplitPane split2 = new JSplitPane(0);
            split2.setBottomComponent(this.getTypesControl());
            split2.setTopComponent(this.getChildControl());
            split2.setDividerLocation(0.2);
            this.jSplitPane.setLeftComponent(split2);
            this.jSplitPane.setOneTouchExpandable(true);
            try {
                if (this.hasManyFeatureTypes()) {
                    this.jSplitPane.setDividerLocation(0.2);
                } else {
                    this.jSplitPane.setDividerLocation(0.0);
                }
            }
            catch (DataException ex) {
                LOG.error("Error getting the number of feature types", (Throwable)ex);
            }
        }
        return this.jSplitPane;
    }

    private JComponent getChildControl() {
        final JList l = new JList();
        DefaultListModel<ListElement> model = new DefaultListModel<ListElement>();
        FeatureStore store = this.model.getFeatureStore();
        model.addElement(new ListElement(store.getName(), (Object)store));
        for (String childName : store.getChildren().keySet()) {
            model.addElement(new ListElement(childName, store.getChildren().get((Object)childName)));
        }
        l.setModel(model);
        l.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                FeatureStore s = (FeatureStore)ListElement.getSelected((JList)l);
                if (s != null) {
                    FeatureTypesTablePanel.this.doSelectStore(s);
                }
            }
        });
        return l;
    }

    private void doSelectStore(FeatureStore featureStore) {
        try {
            this.model = new FeatureStoreModel(featureStore, featureStore.createFeatureQuery());
            this.tablePanel = new FeatureTablePanel(this.model.getCurrentFeatureTableModel());
            this.getJSplitPane().setRightComponent(this.tablePanel);
        }
        catch (BaseException e) {
            throw new RuntimeException("Error creating a new FeatureTablePanel to show store '" + featureStore.getName() + "'.", e);
        }
    }
}

