/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.GetFeatureAtException;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.SetFeatureValueException;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.SupportDisposable;
import org.gvsig.tools.dispose.impl.DisposableHelper;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.observer.ComplexNotification;
import org.gvsig.tools.observer.ComplexObserver;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTableModel
extends AbstractTableModel
implements ComplexObserver,
SupportDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureTableModel.class);
    private static final long serialVersionUID = -2488157521902851301L;
    private FeaturePagingHelper pagingHelper;
    private final DisposableHelper disposableHelper;
    private EditableFeature editableFeature;
    private boolean selectionLocked = false;
    private final FilteredLogger filterlogger;
    private static final int STATUS_OK = 0;
    private static final int STATUS_ERR_LOADFEATURES = 1;
    private static final int STATUS_ERR_LOADFEATURETYPE = 2;
    private int status = 0;
    private final DelayAction delayAction = new DelayAction();

    public FeatureTableModel(FeatureStore featureStore, FeatureQuery featureQuery) throws BaseException {
        this(featureStore, featureQuery, 100);
    }

    public FeatureTableModel(FeatureStore featureStore, FeatureQuery featureQuery, int pageSize) throws BaseException {
        this(DALLocator.getDataManager().createFeaturePagingHelper(featureStore, featureQuery, pageSize));
    }

    protected FeatureTableModel(FeaturePagingHelper helper) {
        this.disposableHelper = new DisposableHelper((Disposable)this);
        this.pagingHelper = helper;
        this.filterlogger = new FilteredLogger(LOGGER, "SimpleFeaturesTableModel", 30000L);
        this.initialize();
    }

    @Override
    public int getColumnCount() {
        switch (this.status) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                return 0;
            }
        }
        FeatureType featureType = this.getFeatureType();
        return featureType.size();
    }

    @Override
    public int getRowCount() {
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                return 0;
            }
        }
        try {
            long totalSize = this.getHelper().getTotalSize();
            if (totalSize > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)totalSize;
        }
        catch (ConcurrentDataModificationException e) {
            LOGGER.debug("Error while getting the total size of the set", (Throwable)e);
            this.delayAction.addAction(1);
            return 0;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                return null;
            }
        }
        try {
            Feature feature = this.getFeatureAt(rowIndex);
            if (feature == null) {
                return null;
            }
            Object value = this.getFeatureValue(feature, columnIndex);
            return value;
        }
        catch (Throwable ex) {
            this.filterlogger.warn("Not been able to retrieve feature value", ex);
            return null;
        }
    }

    public Feature getFeatureAt(int rowIndex) {
        try {
            return this.getHelper().getFeatureAt((long)rowIndex);
        }
        catch (BaseException ex) {
            throw new GetFeatureAtException(rowIndex, ex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        FeatureAttributeDescriptor attributeDesc = this.internalGetFeatureDescriptorForColumn(columnIndex);
        if (attributeDesc == null) {
            return super.getColumnClass(columnIndex);
        }
        Class<?> clazz = attributeDesc.getObjectClass();
        return clazz == null ? super.getColumnClass(columnIndex) : clazz;
    }

    @Override
    public String getColumnName(int column) {
        FeatureAttributeDescriptor attributeDesc = this.internalGetFeatureDescriptorForColumn(column);
        return attributeDesc.getName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.getFeatureStore().isEditing()) {
            FeatureAttributeDescriptor attributeDesc = this.internalGetFeatureDescriptorForColumn(columnIndex);
            return !attributeDesc.isReadOnly();
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Object currentValue;
        Feature feature = this.getFeatureAt(rowIndex);
        if (!(feature == null || value == (currentValue = this.getFeatureValue(feature, columnIndex)) || value != null && value.equals(currentValue))) {
            try {
                this.editableFeature = this.setFeatureValue(feature, columnIndex, value);
                EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
                EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_UPDATE_FEATURE", null, (DataStore)this.getHelper().getFeatureStore(), (Feature)this.editableFeature);
                if (notification.isCanceled()) {
                    return;
                }
                if (notification.shouldValidateTheFeature() && !editingNotificationManager.validateFeature(feature)) {
                    return;
                }
                this.getHelper().update(this.editableFeature);
                this.getHelper().reloadCurrentPage();
                this.fireTableCellUpdated(rowIndex, columnIndex);
                editingNotificationManager.notifyObservers((Object)this, "AFTER_UPDATE_FEATURE", null, (DataStore)this.getHelper().getFeatureStore(), (Feature)this.editableFeature);
                this.editableFeature = null;
            }
            catch (BaseException ex) {
                throw new SetFeatureValueException(rowIndex, columnIndex, value, ex);
            }
            finally {
                this.editableFeature = null;
            }
        }
    }

    public FeaturePagingHelper getHelper() {
        return this.pagingHelper;
    }

    public void setFeatureType(FeatureType featureType) {
        this.getFeatureQuery().setFeatureType(featureType);
        this.reloadFeatures();
        this.selectionLocked = true;
        try {
            this.fireTableStructureChanged();
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't reload changed table");
        }
        finally {
            this.selectionLocked = false;
        }
    }

    public void setSelectionUp(boolean selectionUp) {
        if (selectionUp) {
            this.delayAction.addAction(32);
        } else {
            this.delayAction.addAction(128);
        }
    }

    protected void fireTableChanged() {
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1));
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof ComplexNotification) {
            this.delayAction.addAction(1);
        } else if (observable.equals(this.getFeatureStore()) && notification instanceof FeatureStoreNotification) {
            String type;
            FeatureStoreNotification fsNotification = (FeatureStoreNotification)notification;
            switch (type = fsNotification.getType()) {
                case "after_Delete_Feature": 
                case "after_Insert_Feature": {
                    this.delayAction.addAction(2, fsNotification.getFeature());
                    break;
                }
                case "after_Update_Feature": {
                    this.delayAction.addAction(4, fsNotification.getFeature());
                    break;
                }
                case "after_Update_Type": {
                    this.delayAction.addAction(8, (FeatureType)fsNotification.getFeatureType());
                    break;
                }
                case "Transform_Change": 
                case "after_Undo_DataStore": 
                case "after_Redo_DataStore": 
                case "after_refresh": {
                    this.delayAction.addAction(1);
                    break;
                }
                case "after_FinishEditing_DataStore": 
                case "after_StartEditing_DataStore": 
                case "after_CancelEditing_DataStore": {
                    this.delayAction.addAction(16, (FeatureType)fsNotification.getFeatureType());
                    break;
                }
                case "after_SelectionChange_DataStore": {
                    this.delayAction.addAction(256);
                    break;
                }
                default: {
                    LOGGER.debug("update: skip notification(" + type + ")");
                }
            }
        }
    }

    protected void updatePaginHelperWithHiddenColums() {
        FeatureQuery query = this.getHelper().getFeatureQuery();
        if (this.getHelper().getFeatureStore().isEditing()) {
            if (query.hasConstantsAttributeNames()) {
                query.clearConstantsAttributeNames();
            }
        } else {
            query.setConstantsAttributeNames(this.getHiddenColumnNames());
        }
        try {
            this.getHelper().reload();
        }
        catch (BaseException ex) {
            LOGGER.warn("Can't reload paging-helper.", (Throwable)ex);
        }
    }

    protected String[] getHiddenColumnNames() {
        return null;
    }

    public FeatureStore getFeatureStore() {
        return this.getHelper().getFeatureStore();
    }

    public FeatureAttributeDescriptor getDescriptorForColumn(int columnIndex) {
        return this.internalGetFeatureDescriptorForColumn(columnIndex);
    }

    protected FeatureAttributeDescriptor internalGetFeatureDescriptorForColumn(int columnIndex) {
        FeatureType featureType = this.getFeatureType();
        return featureType == null ? null : featureType.getAttributeDescriptor(columnIndex);
    }

    protected void initialize() {
        this.pagingHelper.getFeatureStore().addObserver((Observer)this);
    }

    protected Object getFeatureValue(Feature feature, int columnIndex) {
        return feature.get(columnIndex);
    }

    protected EditableFeature setFeatureValue(Feature feature, int columnIndex, Object value) {
        EditableFeature theEditableFeature = feature.getEditable();
        theEditableFeature.set(columnIndex, value);
        return theEditableFeature;
    }

    public FeatureQuery getFeatureQuery() {
        return this.getHelper().getFeatureQuery();
    }

    protected FeatureType getFeatureType() {
        return this.getHelper().getFeatureType();
    }

    private boolean reloadFeaturesIfFeatureCountChanged(Feature feature) {
        if (this.editableFeature == null || !this.editableFeature.equals(feature)) {
            this.reloadFeatures();
            this.selectionLocked = true;
            try {
                this.fireTableDataChanged();
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't reload changed table");
            }
            finally {
                this.selectionLocked = false;
            }
            return true;
        }
        return false;
    }

    private boolean reloadFeaturesIfFeatureUpdated(Feature feature) {
        if (this.editableFeature == null || !this.editableFeature.equals(feature)) {
            this.reloadFeatures();
            return true;
        }
        return false;
    }

    private boolean reloadFeatureTypeIfTypeChanged(FeatureType updatedType) {
        if (updatedType != null && updatedType.getId().equals(this.getFeatureType().getId())) {
            this.setFeatureType(updatedType);
            return true;
        }
        return false;
    }

    private void reloadAll() {
        this.reloadFeatureType();
    }

    private void reloadFeatureType() {
        try {
            String ftypeid = this.getHelper().getFeatureType().getId();
            FeatureType ftype = this.getHelper().getFeatureStore().getFeatureType(ftypeid);
            this.setFeatureType(ftype);
        }
        catch (DataException e) {
            LOGGER.warn("Can't reload featuretype", (Throwable)e);
            this.status = 2;
        }
    }

    private void reloadFeatures() {
        switch (this.status) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                return;
            }
        }
        try {
            this.getHelper().reload();
        }
        catch (BaseException ex) {
            LOGGER.warn("Can't reload features", (Throwable)ex);
            this.status = 1;
        }
    }

    public boolean isSelectionLocked() {
        return this.selectionLocked;
    }

    public void dispose() {
        this.disposableHelper.dispose((SupportDisposable)this);
    }

    public void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.pagingHelper);
        this.pagingHelper = null;
    }

    private class DelayAction
    extends Timer
    implements ActionListener,
    Runnable {
        private static final int ACTION_NONE = 0;
        private static final int ACTION_RELOADALL = 1;
        private static final int ACTION_RELOAD_IF_FEATURE_COUNT_CHANGED = 2;
        private static final int ACTION_RELOAD_IF_FEATURE_UPDATED = 4;
        private static final int ACTION_RELOAD_IF_FEATURE_TYPE_CHANGED = 8;
        private static final int ACTION_RELOAD_FEATURE_TYPE = 16;
        private static final int ACTION_ENABLE_SELECTION_UP = 32;
        private static final int ACTION_RELOAD_ALL_FEATURES = 64;
        private static final int ACTION_DISABLE_SELECTION_UP = 128;
        private static final int ACTION_UPDATE_SELECTION = 256;
        private final Bitmask current_actions;
        private Feature feature;
        private FeatureType featureType;

        public DelayAction() {
            super(1000, null);
            this.current_actions = new Bitmask(0);
            this.setRepeats(false);
            this.reset();
            this.addActionListener(this);
        }

        public final void reset() {
            this.current_actions.clearAll();
            this.feature = null;
            this.featureType = null;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.run();
        }

        private String getActionsLabel(Bitmask actions) {
            if (actions.isCleanAll()) {
                return "NONE";
            }
            StringBuilder builder = new StringBuilder();
            boolean needSeparator = false;
            if (actions.isSet(1)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("RELOADALL");
            }
            if (actions.isSet(2)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("RELOAD_IF_FEATURE_COUNT_CHANGED");
            }
            if (actions.isSet(4)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("RELOAD_IF_FEATURE_UPDATED");
            }
            if (actions.isSet(8)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("RELOAD_IF_FEATURE_TYPE_CHANGED");
            }
            if (actions.isSet(16)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("RELOAD_FEATURE_TYPE");
            }
            if (actions.isSet(64)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("RELOAD_ALL_FEATURES");
            }
            if (actions.isSet(128)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("DISABLE_SELECTION_UP");
            }
            if (actions.isSet(32)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("ENABLE_SELECTION_UP");
            }
            if (actions.isSet(256)) {
                if (needSeparator) {
                    builder.append("|");
                }
                needSeparator = true;
                builder.append("UPDATE_SELECTION");
            }
            if (!needSeparator) {
                builder.append(actions.get());
            }
            return builder.toString();
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
                return;
            }
            this.stop();
            boolean needFireTableChanged = false;
            if (this.current_actions.isSet(1)) {
                this.current_actions.clear(95);
                FeatureTableModel.this.reloadAll();
            }
            if (this.current_actions.isSet(16)) {
                this.current_actions.clear(94);
                FeatureTableModel.this.reloadFeatureType();
                FeatureTableModel.this.updatePaginHelperWithHiddenColums();
            }
            if (this.current_actions.isSet(64)) {
                this.current_actions.clear(78);
                FeatureTableModel.this.reloadFeatures();
                needFireTableChanged = true;
            }
            if (this.current_actions.isSet(8) && FeatureTableModel.this.reloadFeatureTypeIfTypeChanged(this.featureType)) {
                this.current_actions.clear(14);
            }
            if (this.current_actions.isSet(2) && FeatureTableModel.this.reloadFeaturesIfFeatureCountChanged(this.feature)) {
                this.current_actions.clear(6);
            }
            if (this.current_actions.isSet(4) && FeatureTableModel.this.reloadFeaturesIfFeatureUpdated(this.feature)) {
                this.current_actions.clear(4);
                needFireTableChanged = true;
            }
            if (this.current_actions.isSet(32)) {
                if (!FeatureTableModel.this.getHelper().isSelectionUp()) {
                    FeatureTableModel.this.getHelper().setSelectionUp(true);
                    this.current_actions.clear(256);
                }
                this.current_actions.clear(160);
                needFireTableChanged = true;
            } else if (this.current_actions.isSet(128)) {
                if (FeatureTableModel.this.getHelper().isSelectionUp()) {
                    FeatureTableModel.this.getHelper().setSelectionUp(false);
                    this.current_actions.clear(256);
                }
                this.current_actions.clear(160);
                needFireTableChanged = true;
            }
            if (this.current_actions.isSet(256)) {
                if (FeatureTableModel.this.getHelper().isSelectionUp()) {
                    try {
                        FeatureTableModel.this.getHelper().reloadCurrentPage();
                    }
                    catch (Throwable th) {
                        LOGGER.debug("No se ha podido recargar la pagina actual de la tabla", th);
                    }
                }
                needFireTableChanged = true;
            }
            if (needFireTableChanged) {
                FeatureTableModel.this.fireTableChanged();
            }
            this.reset();
        }

        public void addAction(int action) {
            this.addAction(action, null, null);
        }

        public void addAction(int action, Feature feature) {
            this.addAction(action, feature, null);
        }

        public void addAction(int action, FeatureType featureType) {
            this.addAction(action, null, featureType);
        }

        public void addAction(int action, Feature feature, FeatureType featureType) {
            this.feature = feature;
            this.featureType = featureType;
            this.current_actions.set(action);
            if (this.current_actions.isSetAny()) {
                this.start();
            }
        }
    }

    public static class Bitmask {
        private int mask;

        public Bitmask(int initialmask) {
            this.mask = initialmask;
        }

        public boolean isSetBit(int pos) {
            return (this.mask & 1 << pos) != 0;
        }

        public boolean isSet(int bits) {
            return (this.mask & bits) == bits;
        }

        public boolean isSetAny() {
            return this.mask != 0;
        }

        public boolean isCleanAll() {
            return this.mask == 0;
        }

        public void set(int bits) {
            this.mask |= bits;
        }

        public int get() {
            return this.mask;
        }

        public void clear(int bits) {
            this.mask = ~bits & this.mask;
        }

        public void clearBit(int pos) {
            this.mask = ~(1 << pos) & this.mask;
        }

        public void clearAll() {
            this.mask = 0;
        }
    }
}

