/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import javax.swing.table.DefaultTableCellRenderer;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;

public class GeometryCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -2470239399517077869L;

    @Override
    protected void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            Geometry geometry = (Geometry)value;
            try {
                String geomTxt = geometry.convertToWKT();
                this.setText(geomTxt);
            }
            catch (GeometryOperationNotSupportedException e) {
                throw new RuntimeException("Error getting as WKT the geometry: " + geometry, e);
            }
            catch (GeometryOperationException e) {
                throw new RuntimeException("Error getting as WKT the geometry: " + geometry, e);
            }
            this.setToolTipText(geometry.getGeometryType().getName());
        }
    }
}

