/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.TextAreaCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryWKTCellRenderer
extends TextAreaCellRenderer {
    private static final Logger logger = LoggerFactory.getLogger(GeometryWKTCellRenderer.class);
    private static final long serialVersionUID = -2470239399517077869L;
    public static final int DEFAULT_MAX_WKT_LENGTH = 800;
    public static final int DEFAULT_MAX_ROW_HEIGHT = 80;

    public GeometryWKTCellRenderer() {
        this(800, 80);
    }

    public GeometryWKTCellRenderer(int maxWKTLength, int maxRowHeight) {
        super(maxWKTLength, maxRowHeight);
    }

    @Override
    protected String getCellText(Object value, int row, int column) {
        if (value != null) {
            try {
                Geometry geometry = (Geometry)value;
                String geomTxt = geometry.convertToWKT();
                if (geomTxt.length() > 200) {
                    geomTxt = geomTxt.substring(0, 200);
                }
                return geomTxt;
            }
            catch (Exception ex) {
                logger.debug("Can't convert the geometry to WKT.", (Throwable)ex);
                return "#ERROR#";
            }
        }
        return "";
    }
}

