/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.swing.dynformfield.CoordinateReferenceSystem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.cresques.Messages;
import org.cresques.cts.IProjection;
import org.gvsig.app.gui.panels.CRSSelectPanelFactory;
import org.gvsig.app.gui.panels.crs.ISelectCrsPanel;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class JDynFormFieldCoordinateReferenceSystem
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected IProjection assignedValue = null;
    protected IProjection currentValue = null;
    protected JTextComponent jtext = null;
    protected JButton jbutton = null;

    public JDynFormFieldCoordinateReferenceSystem(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (IProjection)value;
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        this.contents = new JPanel();
        this.contents.setLayout(new BorderLayout());
        this.jtext = this.getComponentsFactory().getJTextField(this.getDefinition(), null);
        this.jtext.addFocusListener(this);
        this.jtext.setEditable(false);
        this.jbutton = this.getComponentsFactory().getJButton(this.getDefinition(), null);
        this.jbutton.setIcon(this.getIcon("picker-crs"));
        if (StringUtils.equals((CharSequence)"...", (CharSequence)this.jbutton.getText())) {
            this.jbutton.setText("");
        }
        this.jbutton.addActionListener(e -> this.onClickBrowse());
        this.contents.add((Component)this.jtext, "Center");
        this.contents.add((Component)this.jbutton, "After");
        this.contents.setVisible(true);
        this.setValue(this.assignedValue);
    }

    public void onClickBrowse() {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
        ISelectCrsPanel csSelect = CRSSelectPanelFactory.getUIFactory().getSelectCrsPanel(this.currentValue, true);
        ToolsSwingLocator.getWindowManager().showWindow((JComponent)csSelect, Messages.getText((String)"selecciona_sistema_de_referencia"), WindowManager.MODE.DIALOG);
        if (csSelect.isOkPressed()) {
            this.currentValue = csSelect.getProjection();
            this.jtext.setText(this.currentValue.getAbrev());
        }
    }

    public boolean hasValidValue() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireFieldExitEvent();
    }

    public void setValue(Object value) {
        IProjection x = null;
        try {
            x = (IProjection)this.getDefinition().getDataType().coerce(value);
        }
        catch (CoercionException e) {
            throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getMessage());
        }
        this.currentValue = x;
        if (x != null) {
            this.jtext.setText(x.getAbrev());
        }
        this.assignedValue = x;
    }

    public Object getValue() {
        return this.currentValue;
    }
}

