/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.IBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MoveBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.CompoundBehavior;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.MoveEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AbstractCircleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.CircleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.fmap.mapcontrol.tools.MapTool;
import org.gvsig.fmap.mapcontrol.tools.PanListenerImpl;
import org.gvsig.fmap.mapcontrol.tools.ZoomInListenerImpl;
import org.gvsig.fmap.mapcontrol.tools.ZoomOutRightButtonListener;

public class BaseMapTool
extends AbstractCircleListener
implements MapTool,
ActionListener,
IBehavior,
ToolListener,
PanListener,
PointListener,
PolylineListener,
RectangleListener {
    protected int type = 0;
    protected ToolListener listener = null;
    protected IBehavior behavior = null;
    protected boolean isCancelDrawing = false;
    private String name;

    public BaseMapTool(int type) {
        this.setType(type);
    }

    public BaseMapTool(ToolListener listener) {
        this.setListener(listener);
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image getImageCursor() {
        return null;
    }

    @Override
    public boolean cancelDrawing() {
        return this.isCancelDrawing;
    }

    public void setType(int type) {
        if (this.getMapControl() != null) {
            throw new IllegalStateException("Can't change the type if the tool is already binded to a MapControl.");
        }
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public MapControl getMapControl() {
        return this.behavior.getMapControl();
    }

    @Override
    public void setMapControl(MapControl mc) {
        if (this.behavior.getMapControl() != null) {
            throw new IllegalStateException("The tools is already binded to a MapControl, can't change it.");
        }
        this.behavior.setMapControl(mc);
        switch (this.type) {
            case 1: {
                this.behavior = new PointBehavior(this);
                break;
            }
            case 2: {
                this.behavior = new RectangleBehavior(this);
                break;
            }
            case 21: {
                this.listener = new PanListenerImpl(this.getMapControl());
                this.behavior = new MoveBehavior((PanListener)this.listener);
                this.type = 5;
                break;
            }
            case 20: {
                this.behavior = new CompoundBehavior(new Behavior[]{new RectangleBehavior(new ZoomInListenerImpl(this.getMapControl())), new PointBehavior(new ZoomOutRightButtonListener(this.getMapControl()))});
                this.listener = null;
                this.type = 1;
                break;
            }
            default: {
                throw new IllegalStateException("The type " + this.type + " is not a valid value.");
            }
        }
    }

    private void setListener(ToolListener listener) {
        if (listener instanceof CircleListener) {
            this.setType(5);
            this.listener = listener;
            return;
        }
        if (listener instanceof PointListener) {
            this.setType(1);
            this.listener = listener;
            return;
        }
        if (listener instanceof RectangleListener) {
            this.setType(2);
            this.listener = listener;
            return;
        }
    }

    @Override
    public ToolListener getListener() {
        return this;
    }

    protected void callActionPerformed(Object event, int type, String actionCommand) {
        try {
            ActionEvent actionEvent = new ActionEvent(event, type, actionCommand);
            this.actionPerformed(actionEvent);
        }
        catch (Throwable e) {
            this.isCancelDrawing = true;
        }
    }

    @Override
    public void rectangle(EnvelopeEvent event) throws BehaviorException {
        if (this.listener == null) {
            this.callActionPerformed(event, 8, "rectangle");
            return;
        }
        ((RectangleListener)this.listener).rectangle(event);
    }

    @Override
    public void points(MeasureEvent event) throws BehaviorException {
        this.callActionPerformed(event, 7, "points");
    }

    @Override
    public void pointFixed(MeasureEvent event) throws BehaviorException {
        this.callActionPerformed(event, 6, "pointfixed");
    }

    @Override
    public void polylineFinished(MeasureEvent event) throws BehaviorException {
        this.callActionPerformed(event, 5, "polylinefinished");
    }

    @Override
    public void point(PointEvent event) throws BehaviorException {
        this.callActionPerformed(event, 4, "point");
    }

    @Override
    public void pointDoubleClick(PointEvent event) throws BehaviorException {
        this.callActionPerformed(event, 3, "pointdoubleclicked");
    }

    @Override
    public void move(MoveEvent event) throws BehaviorException {
        this.callActionPerformed(event, 2, "move");
    }

    @Override
    public void circle(MeasureEvent event) throws BehaviorException {
        this.callActionPerformed(event, 1, "measure");
    }

    @Override
    public void paintComponent(MapControlDrawer renderer) {
        this.behavior.paintComponent(renderer);
    }

    @Override
    public void mouseClicked(MouseEvent e) throws BehaviorException {
        this.behavior.mouseClicked(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) throws BehaviorException {
        this.behavior.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) throws BehaviorException {
        this.behavior.mouseExited(e);
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        this.behavior.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        this.behavior.mouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        this.behavior.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        this.behavior.mouseMoved(null);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) throws BehaviorException {
        this.behavior.mouseWheelMoved(e);
    }
}

