/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.LineGeometryImpl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AngleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;

public class TwoLinesBehavior
extends PointBehavior {
    protected boolean isClicked = false;
    protected AngleListener listener;
    private Curve[] twoSegment = new Curve[2];
    protected Point2D cuadrantPoint = null;

    public TwoLinesBehavior(AngleListener mli) {
        super(mli);
        this.listener = mli;
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
        Point interPoint;
        mapControlDrawer.setColor(Color.black);
        if (!ArrayUtils.contains((Object[])this.twoSegment, null) && (interPoint = this.findIntersection(this.twoSegment[0], this.twoSegment[1])) != null) {
            Curve[] curveArray = this.twoSegment;
            int n = curveArray.length;
            for (int i = 0; i < n; ++i) {
                Curve curve = curveArray[i];
                try {
                    Line newLine1 = this.geomManager.createLine(0);
                    newLine1.addVertex(curve.getVertex(0));
                    newLine1.addVertex(interPoint);
                    mapControlDrawer.draw((Geometry)newLine1);
                    continue;
                }
                catch (CreateGeometryException createGeometryException) {
                    // empty catch block
                }
            }
            mapControlDrawer.draw((Geometry)interPoint);
        }
        for (Curve curve : this.twoSegment) {
            this.drawPolyline(mapControlDrawer, curve);
        }
    }

    private Point findIntersection(Curve l1, Curve l2) {
        Point interPoint;
        double y4;
        double x1 = l1.getVertex(0).getX();
        double x2 = l1.getVertex(1).getX();
        double x3 = l2.getVertex(0).getX();
        double x4 = l2.getVertex(1).getX();
        double y1 = l1.getVertex(0).getY();
        double y2 = l1.getVertex(1).getY();
        double y3 = l2.getVertex(0).getY();
        double d = (x1 - x2) * (y3 - (y4 = l2.getVertex(1).getY())) - (y1 - y2) * (x3 - x4);
        if (d == 0.0) {
            return null;
        }
        try {
            double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
            double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
            interPoint = this.geomManager.createPoint(xi, yi, 0);
        }
        catch (CreateGeometryException ex) {
            return null;
        }
        return interPoint;
    }

    protected void drawPolyline(MapControlDrawer mapControlDrawer, Curve curve) {
        try {
            if (curve != null && curve.isValid()) {
                mapControlDrawer.draw((Geometry)curve);
            }
        }
        catch (Exception ex) {
            LOG.warn("Can't draw polyline", (Throwable)ex);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (!this.isMyButton(e)) {
            return;
        }
        PointEvent event = new PointEvent(e.getPoint(), e, this.getMapControl());
        this.listener.point(event);
        this.processEvent(event);
        LineGeometryImpl line1 = null;
        if (this.twoSegment[0] != null) {
            line1 = new LineGeometryImpl(this.twoSegment[0].getVertex(0), this.twoSegment[0].getVertex(1));
        }
        LineGeometryImpl line2 = null;
        if (this.twoSegment[1] != null) {
            line2 = new LineGeometryImpl(this.twoSegment[1].getVertex(0), this.twoSegment[1].getVertex(1));
        }
        if (line1 != null && line2 != null) {
            this.listener.angle(line1, line2, event.getMapPoint());
        }
    }

    protected void processEvent(PointEvent event) throws BehaviorException {
        Point2D screenPoint = event.getPoint();
        MapControl mapCtrl = this.getMapControl();
        ViewPort vp = mapCtrl.getMapContext().getViewPort();
        Point mapPoint = vp.convertToMapPoint(screenPoint);
        Line segment = this.getSegmentFrom(mapPoint);
        if (segment == null) {
            return;
        }
        this.twoSegment[1] = this.twoSegment[0];
        this.twoSegment[0] = segment;
    }

    protected List<MultiLine> getPossibleGeometriesFromLayers(Point mapPoint) {
        ArrayList<MultiLine> geoms = new ArrayList<MultiLine>();
        try {
            MapControl mapCtrl = this.getMapControl();
            FLayer[] sel = mapCtrl.getMapContext().getLayers().getActives();
            for (int i = 0; i < sel.length; ++i) {
                FLayer layer = sel[i];
                if (!(layer instanceof FLyrVect)) continue;
                FLyrVect vectLayer = (FLyrVect)layer;
                int layerTolerance = vectLayer.getDefaultTolerance();
                double tolerance = mapCtrl.getViewPort().toMapDistance(layerTolerance);
                FeatureSet featureCandidates = vectLayer.queryByPoint(mapPoint, tolerance, vectLayer.getFeatureStore().getDefaultFeatureType());
                if (featureCandidates.isEmpty()) continue;
                for (Feature feature : featureCandidates) {
                    geoms.add(feature.getDefaultGeometry().cloneGeometry().toLines());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return geoms;
    }

    public Line getSegmentFrom(Point mapPoint) throws BehaviorException {
        List<MultiLine> condidateLines = this.getPossibleGeometriesFromLayers(mapPoint);
        if (condidateLines.isEmpty()) {
            return null;
        }
        Line closestLine = null;
        double closestDist = 0.0;
        for (MultiLine candidateLine : condidateLines) {
            try {
                for (int i = 0; i < candidateLine.getPrimitivesNumber(); ++i) {
                    if (!(candidateLine.getCurveAt(i) instanceof Line)) continue;
                    Line actualLine = (Line)candidateLine.getCurveAt(i);
                    double dist = actualLine.distance((Geometry)mapPoint);
                    if (closestLine != null && !(dist < closestDist)) continue;
                    closestLine = actualLine;
                    closestDist = dist;
                }
            }
            catch (GeometryOperationNotSupportedException ex) {
            }
            catch (GeometryOperationException ex) {
            }
        }
        if (closestLine != null) {
            int vertices = closestLine.getNumVertices();
            double closestSegmentFromLineDist = 0.0;
            Line closestSegmentFromLine = null;
            for (int i = 0; i < vertices - 1; ++i) {
                try {
                    Line line = this.geomManager.createLine(0);
                    line.addVertex(closestLine.getVertex(i));
                    line.addVertex(closestLine.getVertex(i + 1));
                    try {
                        double dist = line.distance((Geometry)mapPoint);
                        if (closestSegmentFromLine != null && !(dist < closestSegmentFromLineDist)) continue;
                        closestSegmentFromLine = line;
                        closestSegmentFromLineDist = dist;
                    }
                    catch (GeometryOperationNotSupportedException ex) {
                    }
                    catch (GeometryOperationException ex) {}
                    continue;
                }
                catch (CreateGeometryException ex) {
                    // empty catch block
                }
            }
            if (closestSegmentFromLine != null) {
                closestLine = closestSegmentFromLine;
            }
        }
        return closestLine;
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        this.mouseMoved(e);
    }

    protected void changeLastPoint(java.awt.Point p) {
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void setListener(ToolListener listener) {
        this.listener = (AngleListener)listener;
    }

    @Override
    public ToolListener getListener() {
        return this.listener;
    }
}

