/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureListenerImpl
implements PolylineListener {
    private static final Logger logger = LoggerFactory.getLogger(MeasureListenerImpl.class);
    protected MapControl mapCtrl;

    public MeasureListenerImpl(MapControl mc) {
        this.mapCtrl = mc;
    }

    @Override
    public void points(MeasureEvent event) {
        double distAll = 0.0;
        ViewPort vp = this.mapCtrl.getMapContext().getViewPort();
        for (int i = 0; i < event.getXs().length - 1; ++i) {
            double dist = 0.0;
            Point p = new Point(event.getXs()[i].intValue(), event.getXs()[i].intValue());
            Point p2 = new Point(event.getXs()[i + 1].intValue(), event.getXs()[i + 1].intValue());
            dist = vp.distanceWorld((Point2D)p, (Point2D)p2);
            logger.debug("Distancia = {}, Distancia Total = {}.", (Object)dist, (Object)(distAll += dist));
        }
    }

    @Override
    public Image getImageCursor() {
        return IconThemeHelper.getImage("cursor-query-area");
    }

    @Override
    public void pointFixed(MeasureEvent event) {
    }

    @Override
    public boolean cancelDrawing() {
        return false;
    }

    @Override
    public void polylineFinished(MeasureEvent event) {
    }
}

