/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.grid;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;

public class Grid {
    public static boolean DefaultShowGrid = false;
    public static double DefaultGridSizeX = 1000.0;
    public static double DefaultGridSizeY = 1000.0;
    public static boolean DefaultAdjustGrid = false;
    public static boolean SHOWGRID = false;
    public static double GRIDSIZEX = 1000.0;
    public static double GRIDSIZEY = 1000.0;
    public static boolean ADJUSTGRID = false;
    private boolean grid = SHOWGRID;
    private double gridSizeX = GRIDSIZEX;
    private double gridSizeY = GRIDSIZEY;
    private ViewPort viewport = null;
    private boolean adjustGrid = ADJUSTGRID;

    public void setViewPort(ViewPort vp) {
        this.viewport = vp;
    }

    public double adjustToGrid(Point2D point) {
        if (this.adjustGrid) {
            Point2D.Double auxp = new Point2D.Double(0.0, 0.0);
            double x = (point.getX() + this.gridSizeX) % this.gridSizeX - ((Point2D)auxp).getX() % this.gridSizeX;
            double y = (point.getY() + this.gridSizeY) % this.gridSizeY - ((Point2D)auxp).getY() % this.gridSizeY;
            Point2D p = (Point2D)point.clone();
            if (x > this.gridSizeX / 2.0) {
                x -= this.gridSizeX;
            }
            if (y > this.gridSizeY / 2.0) {
                y -= this.gridSizeY;
            }
            point.setLocation(point.getX() - x, point.getY() - y);
            return p.distance(point);
        }
        return Double.MAX_VALUE;
    }

    public void drawGrid(MapControlDrawer mapControlDrawer) {
        if (!this.grid) {
            return;
        }
        if (this.viewport.fromMapDistance(this.gridSizeX) > 3 && this.viewport.fromMapDistance(this.gridSizeY) > 3) {
            mapControlDrawer.setColor(Color.lightGray);
            Envelope extent = this.viewport.getAdjustedExtent();
            Point2D.Double auxp = new Point2D.Double(0.0, 0.0);
            if (extent == null) {
                return;
            }
            for (double i = extent.getMinimum(0); i < extent.getMaximum(0) + this.gridSizeX; i += this.gridSizeX) {
                for (double j = extent.getMinimum(1); j < extent.getMaximum(1) + this.gridSizeY; j += this.gridSizeY) {
                    Point2D.Double po = new Point2D.Double(i, j);
                    Point2D point = this.viewport.fromMapPoint((Point2D)po);
                    double x = (((Point2D)po).getX() + this.gridSizeX) % this.gridSizeX - ((Point2D)auxp).getX() % this.gridSizeX;
                    double y = (((Point2D)po).getY() + this.gridSizeY) % this.gridSizeY - ((Point2D)auxp).getY() % this.gridSizeY;
                    x = point.getX() - (double)this.viewport.fromMapDistance(x);
                    y = point.getY() + (double)this.viewport.fromMapDistance(y);
                    mapControlDrawer.drawRect((int)x, (int)y, 1, 1);
                }
            }
        }
    }

    public void setShowGrid(boolean b) {
        this.grid = b;
    }

    public boolean isShowGrid() {
        return this.grid;
    }

    public void setAdjustGrid(boolean b) {
        this.adjustGrid = b;
    }

    public boolean isAdjustGrid() {
        return this.adjustGrid;
    }

    public double getGridSizeX() {
        return this.gridSizeX;
    }

    public double getGridSizeY() {
        return this.gridSizeY;
    }

    public void setGridSizeX(double gridSize) {
        this.gridSizeX = gridSize;
    }

    public void setGridSizeY(double gridSize) {
        this.gridSizeY = gridSize;
    }
}

