/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.focus;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class FormFocusTraversalPolicy
extends FocusTraversalPolicy {
    private ArrayList m_focus_list = new ArrayList();
    private HashMap m_comp_map = new HashMap();

    public FormFocusTraversalPolicy(Collection components) {
        this.rebuildPolicy(components);
    }

    public void rebuildPolicy(Collection components) {
        this.m_focus_list.clear();
        this.m_comp_map.clear();
        this.m_focus_list.addAll(components);
        for (int index = 0; index < this.m_focus_list.size(); ++index) {
            Component comp = (Component)this.m_focus_list.get(index);
            this.m_comp_map.put(comp, new Integer(index));
        }
    }

    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        Integer idx = (Integer)this.m_comp_map.get(aComponent);
        if (idx == null) {
            return this.getFirstComponent(focusCycleRoot);
        }
        int ival = idx;
        if (++ival >= this.m_focus_list.size()) {
            ival = 0;
        }
        return (Component)this.m_focus_list.get(ival);
    }

    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        Integer idx = (Integer)this.m_comp_map.get(aComponent);
        if (idx == null) {
            return this.getFirstComponent(focusCycleRoot);
        }
        int ival = idx;
        if (--ival < 0) {
            ival = 0;
        }
        return (Component)this.m_focus_list.get(ival);
    }

    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.getFirstComponent(focusCycleRoot);
    }

    public Component getFirstComponent(Container focusCycleRoot) {
        if (this.m_focus_list.size() > 0) {
            return (Component)this.m_focus_list.get(0);
        }
        return null;
    }

    public Component getInitialComponent(Window window) {
        return this.getFirstComponent(window);
    }

    public Component getLastComponent(Container focusCycleRoot) {
        if (this.m_focus_list.size() > 0) {
            return (Component)this.m_focus_list.get(this.m_focus_list.size() - 1);
        }
        return null;
    }
}

