/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal;

import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.SupportTransactions;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.observer.Observable;

public interface DataTransaction
extends Disposable,
AutoCloseable,
Observable {
    public static void rollbackQuietly(DataTransaction transaction) {
        if (transaction == null) {
            return;
        }
        transaction.rollbackQuietly();
    }

    public static void close(DataTransaction transaction) {
        if (transaction == null) {
            return;
        }
        try {
            transaction.close();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't close transaction", ex);
        }
    }

    public static void add(DataTransaction transaction, DataServerExplorer explorer) throws DataException {
        if (transaction == null) {
            return;
        }
        transaction.add(explorer);
    }

    public static void add(DataTransaction transaction, DataServerExplorer explorer, boolean local) throws DataException {
        if (transaction == null) {
            return;
        }
        transaction.add(explorer, local);
    }

    public static void add(DataTransaction transaction, FeatureStore store, boolean local) throws DataException {
        if (transaction == null) {
            return;
        }
        transaction.add((DataStore)store, local);
    }

    public String getCode();

    public void begin() throws DataException;

    public void commit() throws DataException;

    public void rollback() throws DataException;

    public void rollbackQuietly();

    public void add(DataStore var1) throws DataException;

    public void add(DataStore var1, boolean var2) throws DataException;

    public void add(DataServerExplorer var1) throws DataException;

    public void add(DataServerExplorer var1, boolean var2) throws DataException;

    public void add(Disposable var1) throws DataException;

    public void add(DataServerExplorer var1, String var2);

    public void add(DataServerExplorer var1, String var2, boolean var3);

    public void add(DataStore var1, String var2);

    public void add(DataStore var1, String var2, boolean var3);

    public void add(SupportTransactions var1, boolean var2) throws DataException;

    public void remove(DataStore var1) throws DataException;

    public void remove(DataServerExplorer var1);

    public boolean isInProgress();

    public boolean contains(DataServerExplorer var1);

    public boolean contains(DataStore var1);

    public FeatureStore getFeatureStore(String var1);

    public DataServerExplorer getServerExplorer(String var1);

    public void setKeepEditingMode(DataStore var1, boolean var2);
}

