/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature;

import org.gvsig.fmap.dal.feature.FeatureRule;
import org.gvsig.tools.util.Bitmask;

public abstract class AbstractFeatureRule
implements FeatureRule {
    protected String name;
    protected String description;
    protected Bitmask checkwhen;

    protected AbstractFeatureRule(String name, String description) {
        this(name, description, 3);
    }

    protected AbstractFeatureRule(String name, String description, boolean checkAtUpdate, boolean checkAtFinishEdition) {
        this(name, description, (checkAtUpdate ? 1 : 0) | (checkAtFinishEdition ? 2 : 0));
    }

    protected AbstractFeatureRule(String name, String description, int checkwhenmask) {
        this.name = name;
        this.description = description;
        this.checkwhen = Bitmask.createBitmask((int)checkwhenmask);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean checkAtFinishEditing() {
        return this.checkwhen.isSetBits(1);
    }

    @Override
    public boolean checkAtUpdate() {
        return this.checkwhen.isSetBits(2);
    }

    @Override
    public boolean checkWhen(int mask) {
        return this.checkwhen.isSetBits(mask);
    }

    protected void setCheckWhen(int mask) {
        this.checkwhen.setBits(mask);
    }
}

