/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureCache;
import org.gvsig.fmap.dal.feature.FeatureIndex;
import org.gvsig.fmap.dal.feature.FeatureIndexes;
import org.gvsig.fmap.dal.feature.FeatureLocks;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureStoreTransforms;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.exception.NeedEditingModeException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.undo.UndoRedoStack;
import org.gvsig.tools.util.GetItemWithSizeIsEmptyAndIterator64;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.Size64;

public interface FeatureStore
extends DataStore,
UndoRedoStack,
Cloneable,
Iterable<Feature>,
PropertiesSupport,
Size64 {
    public static final String METADATA_DEFINITION_NAME = "FeatureStore";
    public static final int MODE_UNKNOWN = -1;
    public static final int MODE_QUERY = 0;
    public static final int MODE_FULLEDIT = 1;
    public static final int MODE_APPEND = 2;
    public static final int MODE_PASS_THROUGH = 3;
    public static final int SUBMODE_NONE = 0;
    public static final int SUBMODE_MERGE = 2;

    public static String getLabel(FeatureStore store) {
        if (store == null) {
            return null;
        }
        String label = null;
        try {
            label = store.getName();
            FeatureType ft = store.getDefaultFeatureTypeQuietly();
            if (ft != null && StringUtils.isNotBlank((CharSequence)ft.getLabel())) {
                label = ft.getLabel();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return label;
    }

    public boolean allowWrite();

    public FeatureType getDefaultFeatureType() throws DataException;

    public FeatureType getDefaultFeatureTypeQuietly();

    public FeatureType getFeatureType(String var1) throws DataException;

    public List getFeatureTypes() throws DataException;

    @Override
    public DataStoreParameters getParameters();

    public boolean canWriteGeometry(int var1) throws DataException;

    public Envelope getEnvelope() throws DataException;

    public IProjection getSRSDefaultGeometry() throws DataException;

    public void export(DataServerExplorer var1, String var2, NewFeatureStoreParameters var3, String var4) throws DataException;

    public void copyTo(FeatureStore var1);

    public FeatureQuery createFeatureQuery(String var1, String var2, boolean var3);

    public FeatureQuery createFeatureQuery(String var1);

    public FeatureQuery createFeatureQuery(Expression var1);

    public FeatureQuery createFeatureQuery(Expression var1, String var2, boolean var3);

    public FeatureQuery createFeatureQuery(Expression var1, Expression var2, boolean var3);

    public FeatureQuery createFeatureQuery(String var1, Expression var2, boolean var3);

    public FeatureSet getFeatureSet() throws DataException;

    public FeatureSet getFeatureSet(String var1) throws DataException;

    public FeatureSet getFeatureSet(String var1, String var2) throws DataException;

    public FeatureSet getFeatureSet(String var1, String var2, boolean var3) throws DataException;

    public FeatureSet getFeatureSet(Expression var1) throws DataException;

    public FeatureSet getFeatureSet(Expression var1, String var2) throws DataException;

    public FeatureSet getFeatureSet(Expression var1, String var2, boolean var3) throws DataException;

    public FeatureSet getFeatureSet(FeatureQuery var1) throws DataException;

    public void getFeatureSet(FeatureQuery var1, Observer var2) throws DataException;

    public void getFeatureSet(Observer var1) throws DataException;

    public List<Feature> getFeatures(FeatureQuery var1, int var2);

    public List<Feature> getFeatures(FeatureQuery var1);

    public List<Feature> getFeatures();

    public List<Feature> getFeatures(String var1);

    public List<Feature> getFeatures(String var1, String var2);

    public List<Feature> getFeatures(String var1, String var2, boolean var3);

    public List<Feature> getFeatures(Expression var1);

    public List<Feature> getFeatures(Expression var1, String var2);

    public List<Feature> getFeatures(Expression var1, String var2, boolean var3);

    public GetItemWithSizeIsEmptyAndIterator64<Feature> getFeatures64();

    public GetItemWithSizeIsEmptyAndIterator64<Feature> getFeatures64(String var1);

    public GetItemWithSizeIsEmptyAndIterator64<Feature> getFeatures64(String var1, String var2, boolean var3);

    public GetItemWithSizeIsEmptyAndIterator64<Feature> getFeatures64(FeatureQuery var1, int var2);

    public Feature first() throws DataException;

    public Feature findFirst(String var1) throws DataException;

    public Feature findFirst(String var1, String var2) throws DataException;

    public Feature findFirst(String var1, String var2, boolean var3) throws DataException;

    public Feature findFirst(String var1, Expression var2, boolean var3) throws DataException;

    public Feature findFirst(Expression var1) throws DataException;

    public Feature findFirst(Expression var1, String var2) throws DataException;

    public Feature findFirst(Expression var1, String var2, boolean var3) throws DataException;

    public Feature findFirst(Expression var1, Expression var2, boolean var3) throws DataException;

    public Feature findFirst(FeatureQuery var1) throws DataException;

    public Feature getFeatureByReference(FeatureReference var1) throws DataException;

    public Feature getFeatureByReference(FeatureReference var1, FeatureType var2) throws DataException;

    public void edit() throws DataException;

    public void edit(int var1) throws DataException;

    public void edit(int var1, int var2) throws DataException;

    public int getSubmode();

    public int getMode();

    public void cancelEditing() throws DataException;

    public boolean cancelEditingQuietly();

    public static boolean cancelEditingQuietly(FeatureStore store) {
        if (store == null) {
            return true;
        }
        return store.cancelEditingQuietly();
    }

    public void finishEditing() throws DataException;

    public boolean finishEditingQuietly();

    public static boolean finishEditingQuietly(FeatureStore store) {
        if (store == null) {
            return true;
        }
        return store.finishEditingQuietly();
    }

    public void commitChanges() throws DataException;

    public boolean canCommitChanges() throws DataException;

    public boolean isEditing();

    public boolean isAppending();

    public void update(EditableFeatureType var1) throws DataException;

    public void update(EditableFeature var1) throws DataException;

    public void update(Object ... var1) throws DataException;

    public void delete(Feature var1) throws DataException;

    public void delete(String var1);

    public void delete(Expression var1);

    public void insert(EditableFeature var1) throws DataException;

    public void insert(FeatureSet var1) throws DataException;

    public EditableFeature createNewFeature() throws DataException;

    public EditableFeature createNewFeature(FeatureType var1, Feature var2) throws DataException;

    public EditableFeature createNewFeature(FeatureType var1, boolean var2) throws DataException;

    public EditableFeature createNewFeature(boolean var1) throws DataException;

    public EditableFeature createNewFeature(Feature var1) throws DataException;

    public EditableFeature createNewFeature(JsonObject var1) throws DataException;

    public boolean isAppendModeSupported();

    public void beginEditingGroup(String var1) throws NeedEditingModeException;

    public void endEditingGroup() throws NeedEditingModeException;

    public FeatureIndex createIndex(FeatureType var1, String var2, String var3) throws DataException;

    public FeatureIndex createIndex(String var1, FeatureType var2, String var3, String var4) throws DataException;

    public FeatureIndex createIndex(FeatureType var1, String var2, String var3, Observer var4) throws DataException;

    public FeatureIndex createIndex(String var1, FeatureType var2, String var3, String var4, Observer var5) throws DataException;

    public FeatureIndexes getIndexes();

    public void setSelection(FeatureSet var1) throws DataException;

    public FeatureSelection createFeatureSelection() throws DataException;

    public FeatureSelection createLargeFeatureSelection() throws DataException;

    public FeatureSelection createMemoryFeatureSelection() throws DataException;

    public FeatureSelection getFeatureSelection() throws DataException;

    public FeatureSelection getFeatureSelectionQuietly();

    public boolean isLocksSupported();

    public FeatureLocks getLocks() throws DataException;

    public FeatureStoreTransforms getTransforms();

    public FeatureQuery createFeatureQuery();

    public long getFeatureCount() throws DataException;

    public boolean isKnownEnvelope();

    public boolean hasRetrievedFeaturesLimit();

    public int getRetrievedFeaturesLimit();

    public Feature getFeature(DynObject var1);

    public ExpressionBuilder createExpressionBuilder();

    public ExpressionBuilder createExpression();

    public void createCache(String var1, DynObject var2) throws DataException;

    @Override
    public FeatureCache getCache();

    public boolean isBroken();

    public Throwable getBreakingsCause();

    public boolean isTemporary();

    public void setTemporary(Boolean var1);

    public SpatialIndex wrapSpatialIndex(SpatialIndex var1);

    public FeatureReference getFeatureReference(String var1);

    public long getPendingChangesCount();

    public Feature getSampleFeature();

    public boolean supportReferences();

    public Feature getOriginalFeature(FeatureReference var1);

    public Feature getOriginalFeature(Feature var1);

    public boolean isFeatureModified(FeatureReference var1);

    public boolean isFeatureModified(Feature var1);

    public String getEditingSession();

    public List<FeatureReference> getEditedFeatures();

    public List<FeatureReference> getEditedFeaturesNotValidated();

    public boolean isFeatureSelectionEmpty();

    public boolean isFeatureSelectionAvailable();

    public Iterator<Feature> getFeaturesIterator(Iterator<FeatureReference> var1);

    public Iterable<Feature> getFeaturesIterable(Iterator<FeatureReference> var1);

    public boolean canBeEdited();

    public String getLabel();

    public Predicate<FeatureStoreNotification> setNotificationsFilter(Predicate<FeatureStoreNotification> var1);

    public boolean allowGeometry(String var1, Geometry var2);
}

