/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import opendap.dap.parser.CeParser;
import opendap.dap.parser.Ceparse;
import opendap.dap.parser.ExprParserConstants;
import opendap.dap.parser.ParseException;

class Celex
implements CeParser.Lexer,
ExprParserConstants {
    static final String wordchars1 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\";
    static final String wordcharsn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\";
    static String worddelims = "{}[]:;=,&";
    static final String numchars1 = "+-0123456789";
    static final String numcharsn = "Ee.+-0123456789";
    Ceparse parsestate = null;
    Reader stream = null;
    StringBuilder input = null;
    StringBuilder yytext = null;
    int charno = 0;
    Object lval = null;
    StringBuilder lookahead = null;

    public Celex(Ceparse state) {
        this.reset(state);
    }

    public void reset(Ceparse state) {
        this.parsestate = state;
        this.input = new StringBuilder();
        this.yytext = new StringBuilder();
        this.lookahead = new StringBuilder();
        this.lval = null;
        this.charno = 0;
        this.stream = null;
    }

    void setStream(StringReader stream) {
        this.stream = stream;
    }

    public String getInput() {
        return this.input.toString();
    }

    int peek() throws IOException {
        int c = this.read();
        this.pushback(c);
        return c;
    }

    void pushback(int c) {
        this.lookahead.insert(0, (char)c);
        --this.charno;
    }

    int read() throws IOException {
        int c;
        if (this.lookahead.length() == 0) {
            c = this.stream.read();
            if (c < 0) {
                c = 0;
            }
            ++this.charno;
        } else {
            c = this.lookahead.charAt(0);
            this.lookahead.deleteCharAt(0);
        }
        return c;
    }

    public int yylex() throws ParseException {
        int token = 0;
        this.yytext.setLength(0);
        try {
            int c;
            token = -1;
            while (token < 0 && (c = this.read()) > 0) {
                if (c == 10 || c <= 32 || c == 127) continue;
                if (worddelims.indexOf(c) >= 0) {
                    token = c;
                    continue;
                }
                if (c == 34) {
                    boolean more = true;
                    while (more && (c = this.read()) > 0) {
                        if (c == 34) {
                            more = false;
                        } else if (c == 92 && (c = this.read()) < 0) {
                            more = false;
                        }
                        if (!more) continue;
                        this.yytext.append((char)c);
                    }
                    token = 259;
                    continue;
                }
                if (numchars1.indexOf(c) >= 0) {
                    boolean isnumber = false;
                    this.yytext.append((char)c);
                    while ((c = this.read()) > 0) {
                        if (numcharsn.indexOf(c) < 0) {
                            this.pushback(c);
                            break;
                        }
                        this.yytext.append((char)c);
                    }
                    try {
                        Double number = new Double(this.yytext.toString());
                        isnumber = true;
                    }
                    catch (NumberFormatException nfe) {
                        isnumber = false;
                    }
                    if (isnumber) {
                        c = this.read();
                        if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\".indexOf(c) >= 0) {
                            token = 258;
                            continue;
                        }
                        token = 260;
                        if (c == 0) continue;
                        this.pushback(c);
                        continue;
                    }
                    int dotpoint = this.yytext.toString().indexOf(46);
                    if (dotpoint >= 0) {
                        for (int i = 0; i < dotpoint; ++i) {
                            this.pushback(this.yytext.charAt(i));
                        }
                        this.yytext.setLength(dotpoint);
                    }
                    token = 258;
                    continue;
                }
                if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\".indexOf(c) >= 0) {
                    this.yytext.append((char)c);
                    while ((c = this.read()) > 0) {
                        if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\".indexOf(c) < 0) {
                            this.pushback(c);
                            break;
                        }
                        this.yytext.append((char)c);
                    }
                    token = 258;
                    continue;
                }
                token = c;
            }
            if (token < 0) {
                token = 0;
                this.lval = null;
            } else {
                Object object = this.lval = this.yytext.length() == 0 ? (String)null : this.yytext.toString();
            }
            if (this.parsestate.getDebugLevel() > 0) {
                this.dumptoken(token, (String)this.lval);
            }
            return token;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    void dumptoken(int token, String lval) throws ParseException {
        switch (token) {
            case 259: {
                System.err.printf("TOKEN = |\"%s\"|\n", lval);
                break;
            }
            case 258: 
            case 260: {
                System.err.printf("TOKEN = |%s|\n", lval);
                break;
            }
            default: {
                System.err.printf("TOKEN = |%c|\n", Character.valueOf((char)token));
            }
        }
    }

    static int tohex(int c) throws ParseException {
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        return -1;
    }

    public Object getLVal() {
        return this.lval;
    }

    public void yyerror(String s) {
        System.err.print("yyerror: " + s + "; char " + this.charno);
        if (this.yytext.length() > 0) {
            System.err.print(" near |" + this.yytext + "|");
        }
        System.err.println();
    }

    public void lexerror(String msg) {
        StringBuilder nextline = new StringBuilder();
        try {
            int c;
            while ((c = this.read()) != -1 && c != 10) {
                nextline.append((char)c);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        System.out.printf("Lex error: %s; charno: %d: %s^%s\n", msg, this.charno, this.yytext, nextline);
    }
}

