/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.taskplanning.retrieving;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.gvsig.remoteclient.taskplanning.IRunnableTask;
import org.gvsig.remoteclient.taskplanning.retrieving.RequestManager;
import org.gvsig.remoteclient.taskplanning.retrieving.RetrieveEvent;
import org.gvsig.remoteclient.taskplanning.retrieving.RetrieveListener;
import org.gvsig.remoteclient.taskplanning.retrieving.URLRequest;

public class URLRetrieveTask
implements IRunnableTask {
    private boolean running;
    private boolean cancelled;
    private URLRequest request;
    private Vector listeners = new Vector();
    private RetrieveEvent event = new RetrieveEvent();
    private InputStream is;

    public URLRetrieveTask(URLRequest request, RetrieveListener listener) {
        this.request = request;
        this.addRetrieveListener(listener);
        this.cancelled = false;
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.event.setType(0);
        this.fireEvent();
        this.cancelled = false;
        this.running = true;
        long t = System.currentTimeMillis();
        File f = new File(this.request.getFileName() + System.currentTimeMillis());
        while (f.exists()) {
            f = new File(this.request.getFileName() + ++t);
        }
        try {
            this.event.setType(1);
            this.fireEvent();
            URL url = this.request.getUrl();
            this.request.setFileName(f.getAbsolutePath());
            System.out.println("downloading '" + url + "' to: " + f.getAbsolutePath());
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            byte[] buffer = new byte[262144];
            this.fireEvent();
            this.is = url.openStream();
            this.event.setType(2);
            this.fireEvent();
            if (!this.cancelled) {
                long readed = 0L;
                int i = this.is.read(buffer);
                while (!this.cancelled && i > 0) {
                    dos.write(buffer, 0, i);
                    readed += (long)i;
                    i = this.is.read(buffer);
                }
                dos.close();
            }
            if (this.cancelled) {
                System.out.println("download cancelled (" + url + ")");
                f.delete();
            } else {
                URLRetrieveTask uRLRetrieveTask = this;
                synchronized (uRLRetrieveTask) {
                    RequestManager.getInstance().addDownloadedURLRequest(this.request, f.getAbsolutePath());
                }
            }
            this.running = false;
            if (this.cancelled) {
                this.event.setType(5);
            } else {
                this.event.setType(3);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.event.setType(4);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.event.setType(4);
        }
        this.fireEvent();
    }

    private void fireEvent() {
        for (RetrieveListener listener : this.listeners) {
            listener.transferEventReceived(this.event);
        }
    }

    public void addRetrieveListener(RetrieveListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running && !this.cancelled;
    }

    public URLRequest getRequest() {
        return this.request;
    }

    public Vector getListeners() {
        return this.listeners;
    }

    @Override
    public long getTaskTimeout() {
        return 30000L;
    }
}

