/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.util.FMapUtil;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.EllipticArc;
import org.gvsig.fmap.geom.primitive.Point;

public class DwgEllipse
extends DwgObject
implements IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private double[] center;
    private double[] semiMajorAxisVector;
    private double[] extrusion;
    private double axisRatio;
    private double initAngle;
    private double endAngle;

    public DwgEllipse(int index) {
        super(index);
    }

    public double getAxisRatio() {
        return this.axisRatio;
    }

    public void setAxisRatio(double axisRatio) {
        this.axisRatio = axisRatio;
    }

    public double[] getCenter() {
        return this.center;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public void setEndAngle(double endAngle) {
        this.endAngle = endAngle;
    }

    public double getInitAngle() {
        return this.initAngle;
    }

    public void setInitAngle(double initAngle) {
        this.initAngle = initAngle;
    }

    public double[] getSemiMajorAxisVector() {
        return this.semiMajorAxisVector;
    }

    public void setSemiMajorAxisVector(double[] semiMajorAxisVector) {
        this.semiMajorAxisVector = semiMajorAxisVector;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    @Override
    public boolean has3DData() {
        return this.getCenter()[2] != 0.0;
    }

    @Override
    public double getZ() {
        return this.getCenter()[2];
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        double[] c = this.getCenter();
        double[] semiMajorAxisVector = this.getSemiMajorAxisVector();
        double axisRatio = this.getAxisRatio();
        double angSt = this.getInitAngle();
        double angEnd = this.getEndAngle();
        double angExt = FMapUtil.angleDistance(angSt, angEnd);
        Point axis1Start = (Point)gMan.create(1, this.getGeometrySubType(is3DFile));
        double[] tmp = new double[c.length];
        for (int i = 0; i < c.length; ++i) {
            tmp[i] = c[i] + semiMajorAxisVector[i];
        }
        axis1Start.setCoordinates(tmp);
        Point axis1End = (Point)gMan.create(1, this.getGeometrySubType(is3DFile));
        tmp = new double[c.length];
        for (int i = 0; i < c.length; ++i) {
            tmp[i] = c[i] - semiMajorAxisVector[i];
        }
        axis1End.setCoordinates(tmp);
        Point2D.Double smav = new Point2D.Double(semiMajorAxisVector[0], semiMajorAxisVector[1]);
        Point2D.Double origen = new Point2D.Double(0.0, 0.0);
        double semiMajorAxisLenght = origen.distance(smav);
        double semiMinorAxisLenght = semiMajorAxisLenght * axisRatio;
        EllipticArc ellipse = (EllipticArc)gMan.create(this.getGeometryType(), this.getGeometrySubType(is3DFile));
        ellipse.setPoints(axis1Start, axis1End, semiMinorAxisLenght, -angSt, -angExt);
        return ellipse;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "EllipticArc2DZ";
        }
        return "EllipticArc2D";
    }

    @Override
    public String toString() {
        return "Ellipse";
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        double axisRatio;
        DwgEllipse transformedEntity = null;
        double[] center = this.getCenter();
        Point2D.Double pointAux = new Point2D.Double(center[0] - bPoint[0], center[1] - bPoint[1]);
        double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double laZ = center[2] * scale[2];
        double[] transformedCenter = new double[]{laX, laY, laZ};
        double[] majorAxisVector = this.getSemiMajorAxisVector();
        double[] transformedMajorAxisVector = new double[]{majorAxisVector[0] * scale[0], majorAxisVector[1] * scale[1], majorAxisVector[2] * scale[2]};
        double transformedAxisRatio = axisRatio = this.getAxisRatio();
        double initAngle = this.getInitAngle();
        double endAngle = this.getEndAngle();
        double transformedInitAngle = initAngle + rot;
        if (transformedInitAngle < 0.0) {
            transformedInitAngle += Math.PI * 2;
        } else if (transformedInitAngle > Math.PI * 2) {
            transformedInitAngle -= Math.PI * 2;
        }
        double transformedEndAngle = endAngle + rot;
        if (transformedEndAngle < 0.0) {
            transformedEndAngle += Math.PI * 2;
        } else if (transformedEndAngle > Math.PI * 2) {
            transformedEndAngle -= Math.PI * 2;
        }
        transformedEntity = (DwgEllipse)this.clone();
        transformedEntity.setCenter(transformedCenter);
        transformedEntity.setSemiMajorAxisVector(transformedMajorAxisVector);
        transformedEntity.setAxisRatio(transformedAxisRatio);
        transformedEntity.setInitAngle(transformedInitAngle);
        transformedEntity.setEndAngle(transformedEndAngle);
        dwgObjectsWithoutBlocks.add(transformedEntity);
        handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
    }

    @Override
    public Object clone() {
        DwgEllipse obj = new DwgEllipse(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgEllipse myObj = (DwgEllipse)obj;
        myObj.setAxisRatio(this.axisRatio);
        myObj.setCenter(this.center);
        myObj.setEndAngle(this.endAngle);
        myObj.setExtrusion(this.extrusion);
        myObj.setInitAngle(this.initAngle);
        myObj.setSemiMajorAxisVector(this.semiMajorAxisVector);
    }

    @Override
    public int getGeometryType() {
        return 15;
    }
}

