/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.dwg.lib.util.FMapUtil;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;

public class DwgSolid
extends DwgObject
implements IDwgExtrusionable,
IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private double thickness;
    private double elevation;
    private double[] corner1;
    private double[] corner2;
    private double[] corner3;
    private double[] corner4;
    private double[] extrusion;

    public DwgSolid(int index) {
        super(index);
    }

    public void readDwgSolidV15(int[] data, int offset) throws Exception {
    }

    public double[] getCorner1() {
        return this.corner1;
    }

    public void setCorner1(double[] corner1) {
        this.corner1 = corner1;
    }

    public double[] getCorner2() {
        return this.corner2;
    }

    public void setCorner2(double[] corner2) {
        this.corner2 = corner2;
    }

    public double[] getCorner3() {
        return this.corner3;
    }

    public void setCorner3(double[] corner3) {
        this.corner3 = corner3;
    }

    public double[] getCorner4() {
        return this.corner4;
    }

    public void setCorner4(double[] corner4) {
        this.corner4 = corner4;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    @Override
    public void applyExtrussion() {
        double[] corner1 = this.getCorner1();
        double[] corner2 = this.getCorner2();
        double[] corner3 = this.getCorner3();
        double[] corner4 = this.getCorner4();
        double[] solidExt = this.getExtrusion();
        corner1 = AcadExtrusionCalculator.extrude2(corner1, solidExt);
        corner2 = AcadExtrusionCalculator.extrude2(corner2, solidExt);
        corner3 = AcadExtrusionCalculator.extrude2(corner3, solidExt);
        corner4 = AcadExtrusionCalculator.extrude2(corner4, solidExt);
        this.setCorner1(corner1);
        this.setCorner2(corner2);
        this.setCorner3(corner3);
        this.setCorner4(corner4);
    }

    @Override
    public boolean has3DData() {
        return this.getElevation() != 0.0;
    }

    @Override
    public double getZ() {
        return this.getElevation();
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        int subType = this.getGeometrySubType(is3DFile);
        double[] p1 = this.getCorner1();
        double[] p2 = this.getCorner2();
        double[] p3 = this.getCorner3();
        double[] p4 = this.getCorner4();
        double elev = this.getElevation();
        ArrayList<double[]> pts = new ArrayList<double[]>();
        if (is3DFile) {
            double[] p13d = new double[]{p1[0], p1[1], elev};
            double[] p23d = new double[]{p2[0], p2[1], elev};
            double[] p33d = new double[]{p3[0], p3[1], elev};
            double[] p43d = new double[]{p4[0], p4[1], elev};
            pts.add(p13d);
            pts.add(p23d);
            pts.add(p33d);
            pts.add(p43d);
        } else {
            pts.add(p1);
            pts.add(p2);
            pts.add(p3);
            pts.add(p4);
        }
        return FMapUtil.ptsToPolygon(pts, subType);
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "Solid";
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        DwgSolid transformedEntity = null;
        double[] corner1 = this.getCorner1();
        double[] corner2 = this.getCorner2();
        double[] corner3 = this.getCorner3();
        double[] corner4 = this.getCorner4();
        Point2D.Double pointAux = new Point2D.Double(corner1[0] - bPoint[0], corner1[1] - bPoint[1]);
        double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double[] transformedP1 = new double[]{laX, laY};
        pointAux = new Point2D.Double(corner2[0] - bPoint[0], corner2[1] - bPoint[1]);
        laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double[] transformedP2 = new double[]{laX, laY};
        pointAux = new Point2D.Double(corner3[0] - bPoint[0], corner3[1] - bPoint[1]);
        laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double[] transformedP3 = new double[]{laX, laY};
        pointAux = new Point2D.Double(corner4[0] - bPoint[0], corner4[1] - bPoint[1]);
        laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double[] transformedP4 = new double[]{laX, laY};
        transformedEntity = (DwgSolid)this.clone();
        transformedEntity.setCorner1(transformedP1);
        transformedEntity.setCorner2(transformedP2);
        transformedEntity.setCorner3(transformedP3);
        transformedEntity.setCorner4(transformedP4);
        transformedEntity.setElevation(this.getElevation() * scale[2]);
        dwgObjectsWithoutBlocks.add(transformedEntity);
        handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
    }

    @Override
    public Object clone() {
        DwgSolid obj = new DwgSolid(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgSolid myObj = (DwgSolid)obj;
        myObj.setCorner1(this.corner1);
        myObj.setCorner2(this.corner2);
        myObj.setCorner3(this.corner3);
        myObj.setCorner4(this.corner4);
        myObj.setElevation(this.elevation);
        myObj.setExtrusion(this.extrusion);
        myObj.setThickness(this.thickness);
    }

    @Override
    public int getGeometryType() {
        return 3;
    }
}

