/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v15;

import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgBlockHeader;
import org.gvsig.dwg.lib.readers.v15.AbstractDwg15Reader;

public class DwgBlockHeaderReader15
extends AbstractDwg15Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) throws RuntimeException, CorruptedDwgEntityException {
        if (!(dwgObj instanceof DwgBlockHeader)) {
            throw new RuntimeException("DwgBlockHeaderReader15 solo puede leer DwgBlockControl");
        }
        DwgBlockHeader hdr = (DwgBlockHeader)dwgObj;
        int bitPos = offset;
        ArrayList v = DwgUtil.getBitLong(data, bitPos);
        bitPos = (Integer)v.get(0);
        int numReactors = (Integer)v.get(1);
        hdr.setNumReactors(numReactors);
        v = DwgUtil.getTextString(data, bitPos);
        bitPos = (Integer)v.get(0);
        String name = (String)v.get(1);
        hdr.setName(name);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean flag = (Boolean)v.get(1);
        hdr.setFlag64(flag);
        v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        int xrefplus1 = (Integer)v.get(1);
        hdr.setXRefPlus(xrefplus1);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean xdep = (Boolean)v.get(1);
        hdr.setXdep(xdep);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean anon = (Boolean)v.get(1);
        hdr.setAnonymous(anon);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean hasatts = (Boolean)v.get(1);
        hdr.setHasAttrs(hasatts);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean bxref = (Boolean)v.get(1);
        hdr.setBlkIsXRef(bxref);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean xover = (Boolean)v.get(1);
        hdr.setXRefOverLaid(xover);
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean loaded = (Boolean)v.get(1);
        hdr.setLoaded(loaded);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double bx = (Double)v.get(1);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double by = (Double)v.get(1);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double bz = (Double)v.get(1);
        double[] coord = new double[]{bx, by, bz};
        hdr.setBasePoint(coord);
        v = DwgUtil.getTextString(data, bitPos);
        bitPos = (Integer)v.get(0);
        String pname = (String)v.get(1);
        hdr.setXRefPName(pname);
        int icount = 0;
        while (true) {
            v = DwgUtil.getRawChar(data, bitPos);
            bitPos = (Integer)v.get(0);
            int val = (Integer)v.get(1);
            if (val == 0) break;
            ++icount;
        }
        v = DwgUtil.getTextString(data, bitPos);
        bitPos = (Integer)v.get(0);
        String desc = (String)v.get(1);
        hdr.setBlockDescription(desc);
        v = DwgUtil.getBitLong(data, bitPos);
        bitPos = (Integer)v.get(0);
        int pdsize = (Integer)v.get(1);
        if (pdsize > 0) {
            int count = pdsize + icount;
            bitPos += count;
        }
        DwgHandleReference blkCtrlHdl = new DwgHandleReference();
        bitPos = blkCtrlHdl.read(data, bitPos);
        hdr.setBlockControlHandle(blkCtrlHdl);
        for (int i = 0; i < numReactors; ++i) {
            DwgHandleReference reactor = new DwgHandleReference();
            bitPos = reactor.read(data, bitPos);
        }
        DwgHandleReference xdicObjHdl = new DwgHandleReference();
        bitPos = xdicObjHdl.read(data, bitPos);
        hdr.setXDicObjHandle(xdicObjHdl);
        DwgHandleReference handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        hdr.setNullHandle(handle);
        handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        hdr.setBlockEntityHandle(handle);
        if (!bxref && !xover) {
            handle = new DwgHandleReference();
            bitPos = handle.read(data, bitPos);
            hdr.setFirstEntityHandle(handle);
            handle = new DwgHandleReference();
            bitPos = handle.read(data, bitPos);
            hdr.setLastEntityHandle(handle);
        }
        handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        hdr.setEndBlkEntityHandle(handle);
        if (icount > 0) {
            DwgHandleReference[] insertHandles = new DwgHandleReference[icount];
            for (int i = 0; i < icount; ++i) {
                insertHandles[i] = new DwgHandleReference();
                bitPos = insertHandles[i].read(data, bitPos);
            }
            hdr.setInsertHandles(insertHandles);
        }
        handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        hdr.setLayoutHandle(handle);
    }
}

