/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v15;

import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgSpline;
import org.gvsig.dwg.lib.readers.v15.AbstractDwg15Reader;

public class DwgSplineReader15
extends AbstractDwg15Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) throws RuntimeException, CorruptedDwgEntityException {
        double z;
        double y;
        if (!(dwgObj instanceof DwgSpline)) {
            throw new RuntimeException("ArcReader 15 solo puede leer DwgSpline");
        }
        DwgSpline spline = (DwgSpline)dwgObj;
        int bitPos = offset;
        bitPos = this.headTailReader.readObjectHeader(data, bitPos, spline);
        ArrayList v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        int sc = (Integer)v.get(1);
        spline.setScenario(sc);
        v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        int deg = (Integer)v.get(1);
        spline.setDegree(deg);
        int knotsNumber = 0;
        int controlPointsNumber = 0;
        int fitPointsNumber = 0;
        boolean weight = false;
        if (sc == 2) {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double ft = (Double)v.get(1);
            spline.setFitTolerance(ft);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double x = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
            double[] coord = new double[]{x, y, z};
            spline.setBeginTanVector(coord);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            x = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
            coord = new double[]{x, y, z};
            spline.setEndTanVector(coord);
            v = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)v.get(0);
            fitPointsNumber = (Integer)v.get(1);
        } else if (sc == 1) {
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            boolean rat = (Boolean)v.get(1);
            spline.setRational(rat);
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            boolean closed = (Boolean)v.get(1);
            spline.setClosed(closed);
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            boolean per = (Boolean)v.get(1);
            spline.setPeriodic(per);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double ktol = (Double)v.get(1);
            spline.setKnotTolerance(ktol);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double ctol = (Double)v.get(1);
            spline.setControlTolerance(ctol);
            v = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)v.get(0);
            knotsNumber = (Integer)v.get(1);
            v = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)v.get(0);
            controlPointsNumber = (Integer)v.get(1);
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            weight = (Boolean)v.get(1);
        } else {
            System.out.println("ERROR: Escenario desconocido");
        }
        if (knotsNumber > 0) {
            double[] knotpts = new double[knotsNumber];
            for (int i = 0; i < knotsNumber; ++i) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                knotpts[i] = (Double)v.get(1);
            }
            spline.setKnotPoints(knotpts);
        }
        if (controlPointsNumber > 0) {
            double[][] ctrlpts = new double[controlPointsNumber][3];
            double[] weights = new double[controlPointsNumber];
            for (int i = 0; i < controlPointsNumber; ++i) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double x = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double y2 = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double z2 = (Double)v.get(1);
                ctrlpts[i][0] = x;
                ctrlpts[i][1] = y2;
                ctrlpts[i][2] = z2;
                if (!weight) continue;
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                weights[i] = (Double)v.get(1);
            }
            spline.setControlPoints(ctrlpts);
            if (weight) {
                spline.setWeights(weights);
            }
        }
        if (fitPointsNumber > 0) {
            double[][] fitpts = new double[fitPointsNumber][3];
            for (int i = 0; i < fitPointsNumber; ++i) {
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                double x = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                y = (Double)v.get(1);
                v = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)v.get(0);
                z = (Double)v.get(1);
                fitpts[i][0] = x;
                fitpts[i][1] = y;
                fitpts[i][2] = z;
            }
            spline.setFitPoints(fitpts);
        }
        bitPos = this.headTailReader.readObjectTailer(data, bitPos, spline);
    }
}

