/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v2004;

import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgArc;
import org.gvsig.dwg.lib.objects.DwgAttdef;
import org.gvsig.dwg.lib.objects.DwgAttrib;
import org.gvsig.dwg.lib.objects.DwgBlock;
import org.gvsig.dwg.lib.objects.DwgCircle;
import org.gvsig.dwg.lib.objects.DwgEllipse;
import org.gvsig.dwg.lib.objects.DwgEndblk;
import org.gvsig.dwg.lib.objects.DwgInsert;
import org.gvsig.dwg.lib.objects.DwgLine;
import org.gvsig.dwg.lib.objects.DwgLwPolyline;
import org.gvsig.dwg.lib.objects.DwgMText;
import org.gvsig.dwg.lib.objects.DwgPoint;
import org.gvsig.dwg.lib.objects.DwgPolyline3D;
import org.gvsig.dwg.lib.objects.DwgSeqend;
import org.gvsig.dwg.lib.objects.DwgSolid;
import org.gvsig.dwg.lib.objects.DwgSpline;
import org.gvsig.dwg.lib.objects.DwgText;
import org.gvsig.dwg.lib.objects.DwgVertex3D;
import org.gvsig.dwg.lib.readers.DwgFileVR2004Reader;
import org.gvsig.dwg.lib.readers.IDwgFileReader;
import org.gvsig.dwg.lib.readers.IDwgObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDwg2004Reader
implements IDwgObjectReader {
    private static Logger logger = LoggerFactory.getLogger((String)AbstractDwg2004Reader.class.getName());
    protected IDwgFileReader headTailReader;

    public int readObjectHeader(int[] data, int offset, DwgObject dwgObject) throws RuntimeException, CorruptedDwgEntityException {
        int bitPos = offset;
        Integer mode = (Integer)DwgUtil.getBits(data, 2, bitPos);
        dwgObject.setMode(mode);
        ArrayList v = DwgUtil.getBitLong(data, bitPos += 2);
        bitPos = (Integer)v.get(0);
        int rnum = (Integer)v.get(1);
        dwgObject.setNumReactors(rnum);
        if (dwgObject instanceof DwgLine) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgPoint) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgCircle) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgArc) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgLwPolyline) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgEllipse) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgMText) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgText) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgBlock) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgEndblk) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgPolyline3D) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgVertex3D) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgSeqend) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgInsert) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgAttrib) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgSpline) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgAttdef) {
            dwgObject.setXDicObjFlag(true);
        } else if (dwgObject instanceof DwgSolid) {
            dwgObject.setXDicObjFlag(true);
        } else {
            v = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)v.get(0);
            boolean XdicFlag = (Boolean)v.get(1);
            dwgObject.setXDicObjFlag(XdicFlag);
        }
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean nolinks = (Boolean)v.get(1);
        dwgObject.setNoLinks(nolinks);
        v = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)v.get(0);
        int color = (Integer)v.get(1);
        dwgObject.setColor(color);
        v = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        float ltscale = ((Double)v.get(1)).floatValue();
        Integer ltflag = (Integer)DwgUtil.getBits(data, 2, bitPos);
        Integer psflag = (Integer)DwgUtil.getBits(data, 2, bitPos += 2);
        v = DwgUtil.getBitShort(data, bitPos += 2);
        bitPos = (Integer)v.get(0);
        int invis = (Integer)v.get(1);
        v = DwgUtil.getRawChar(data, bitPos);
        bitPos = (Integer)v.get(0);
        int weight = (Integer)v.get(1);
        return bitPos;
    }

    public int readObjectTailer(int[] data, int offset, DwgObject dwgObject) throws RuntimeException, CorruptedDwgEntityException {
        int bitPos = offset;
        if (dwgObject.getMode() == 0) {
            DwgHandleReference subEntityHandle = new DwgHandleReference();
            bitPos = subEntityHandle.read(data, bitPos);
            dwgObject.setSubEntityHandle(subEntityHandle);
        }
        for (int i = 0; i < dwgObject.getNumReactors(); ++i) {
            DwgHandleReference reactorHandle = new DwgHandleReference();
            bitPos = reactorHandle.read(data, bitPos);
            dwgObject.addReactorHandle(reactorHandle);
        }
        if (!dwgObject.isXDicObjFlag()) {
            DwgHandleReference xDicObjHandle = new DwgHandleReference();
            bitPos = xDicObjHandle.read(data, bitPos);
            dwgObject.setXDicObjHandle(xDicObjHandle);
        }
        if (!dwgObject.isNoLinks()) {
            DwgHandleReference previousHandle = new DwgHandleReference();
            bitPos = previousHandle.read(data, bitPos);
            dwgObject.setPreviousHandle(previousHandle);
            DwgHandleReference nextHandle = new DwgHandleReference();
            bitPos = nextHandle.read(data, bitPos);
            dwgObject.setNextHandle(nextHandle);
        }
        DwgHandleReference handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        dwgObject.setLayerHandle(handle);
        if (dwgObject.getLinetypeFlags() == 3) {
            DwgHandleReference lineTypeHandle = new DwgHandleReference();
            bitPos = lineTypeHandle.read(data, bitPos);
            dwgObject.setLineTypeHandle(lineTypeHandle);
        }
        if (dwgObject.getPlotstyleFlags() == 3) {
            DwgHandleReference plotStyleHandle = new DwgHandleReference();
            bitPos = plotStyleHandle.read(data, bitPos);
            dwgObject.setPlotStyleHandle(plotStyleHandle);
        }
        return bitPos;
    }

    @Override
    public void setFileReader(IDwgFileReader headTailReader) {
        if (!(headTailReader instanceof DwgFileVR2004Reader)) {
            throw new RuntimeException("Tratando de leer entidad de DWG 2004 con" + headTailReader.getClass().getName());
        }
        this.headTailReader = headTailReader;
    }
}

