/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.util;

import org.gvsig.dwg.lib.util.Point3D;

public final class Vector3D {
    public double x;
    public double y;
    public double z;

    public Vector3D() {
    }

    public Vector3D(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3D(Point3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public Vector3D(double xx, double yy, double zz) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void scale(double f) {
        if (f != 1.0) {
            this.x *= f;
            this.y *= f;
            this.z *= f;
        }
    }

    public void normalize() {
        this.scale(1.0 / this.length());
    }

    public void add(Vector3D v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public Vector3D plus(Vector3D v) {
        Vector3D ret = new Vector3D(this);
        ret.add(v);
        return ret;
    }

    public Point3D plus(Point3D p) {
        Point3D ret = new Point3D(p);
        ret.add(this);
        return ret;
    }

    public void sub(Vector3D v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public Point3D minus(Point3D p) {
        Point3D ret = new Point3D(p);
        ret.sub(this);
        ret.scale(-1.0);
        return ret;
    }

    public Vector3D minus(Vector3D v) {
        Vector3D ret = new Vector3D(this);
        ret.sub(v);
        return ret;
    }

    public double mult(Vector3D v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector3D cross(Vector3D v) {
        return new Vector3D(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public String toString() {
        return new String(new StringBuffer().append("<").append(this.x).append(",").append(this.y).append(",").append(this.z).append(">"));
    }
}

