/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.raster.wms.io.WMSLayerNode;
import org.gvsig.raster.wms.io.WMSServerExplorerParameters;
import org.gvsig.remoteclient.exceptions.ServerErrorException;
import org.gvsig.remoteclient.exceptions.WMSException;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wms.WMSClient;
import org.gvsig.remoteclient.wms.WMSDimension;
import org.gvsig.remoteclient.wms.WMSLayer;
import org.gvsig.remoteclient.wms.WMSStatus;
import org.gvsig.remoteclient.wms.WMSStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSConnector {
    private WMSClient client;
    private WMSLayerNode fmapRootLayer;
    private TreeMap<String, WMSLayerNode> layers = new TreeMap();
    private Logger log = LoggerFactory.getLogger(WMSConnector.class);

    public WMSConnector(URL url) throws ConnectException, IOException {
        this.client = new WMSClient(url.toString());
    }

    public String[] getLayerNames() {
        return this.client.getLayerNames();
    }

    public String[] getLayerTitles() {
        return this.client.getLayerTitles();
    }

    public void getCapabilities(URL server) throws RemoteServiceException {
    }

    public File getMap(WMSStatus status, ICancellable cancel) throws RemoteServiceException {
        try {
            return this.client.getMap(status, cancel);
        }
        catch (WMSException e) {
            throw new RemoteServiceException(e.getMessage());
        }
        catch (ServerErrorException e) {
            throw new RemoteServiceException("WMS Unexpected server error." + e.getMessage(), (Throwable)e);
        }
    }

    public void getMap(WMSStatus status, ICancellable cancel, File file) throws RemoteServiceException {
        try {
            URL url = this.client.getGetMapURL(status, cancel);
            this.downloadFile(url, file, cancel);
            String exceptionMessage = this.client.getExceptionMessage(file);
            if (exceptionMessage != null) {
                throw new RemoteServiceException(exceptionMessage);
            }
        }
        catch (IOException e) {
            throw new RemoteServiceException("WMS: error downloading the file. File:" + file.getAbsolutePath() + "...." + e.getMessage());
        }
        catch (ServerErrorException e) {
            throw new RemoteServiceException("WMS Unexpected server error." + e.getMessage());
        }
        catch (WMSException e) {
            throw new RemoteServiceException(e.getMessage());
        }
    }

    public void downloadFile(URL url, File dstFile, ICancellable cancel) throws IOException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        downloader.downloadFile(url, "GET", null, null, dstFile.getAbsolutePath(), cancel, -1);
    }

    public File getLegendGraphic(WMSStatus status, String layerName, ICancellable cancel) throws RemoteServiceException {
        try {
            File f = this.client.getLegendGraphic(status, layerName, cancel);
            return f;
        }
        catch (WMSException f) {
        }
        catch (ServerErrorException e) {
            throw new RemoteServiceException("WMS Unexpected server error." + e.getMessage());
        }
        return null;
    }

    public boolean connect(boolean override, ICancellable cancel) {
        if (override) {
            this.fmapRootLayer = null;
            this.layers.clear();
        }
        return this.client.connect(override, cancel);
    }

    public boolean connect(DataServerExplorerParameters p, boolean override, ICancellable cancel) {
        if (override) {
            this.fmapRootLayer = null;
            this.layers.clear();
        }
        WMSStatus status = new WMSStatus();
        if (p != null && p instanceof WMSServerExplorerParameters) {
            status.setXyAxisOrder(((WMSServerExplorerParameters)p).isXyAxisOrder());
        }
        return this.client.connect(status, override, cancel);
    }

    public boolean connect(ICancellable cancel) {
        return this.client.connect(false, cancel);
    }

    public String getVersion() {
        return this.client.getVersion();
    }

    public String getServiceTitle() {
        return this.client.getServiceInformation().title;
    }

    public Hashtable getOnlineResources() {
        return this.client.getServiceInformation().getSupportedOperationsByName();
    }

    public Vector getFormats() {
        return this.client.getFormats();
    }

    public Vector getInfoFormats() {
        return this.client.getInfoFormats();
    }

    public boolean isQueryable() {
        return this.client.isQueryable();
    }

    public boolean hasLegendGraphic() {
        return this.client.hasLegendGraphic();
    }

    public WMSLayerNode getLayersTree() {
        if (this.fmapRootLayer == null) {
            if (this.client.getLayersRoot() == null) {
                this.client.connect(false, null);
            }
            WMSLayer clientRoot = this.client.getLayersRoot();
            this.fmapRootLayer = this.parseTree(clientRoot, null);
        }
        return this.fmapRootLayer;
    }

    private WMSLayerNode parseTree(WMSLayer node, WMSLayerNode parentNode) {
        WMSLayerNode myNode = new WMSLayerNode();
        myNode.setName(node.getName());
        myNode.setTitle(node.getTitle());
        myNode.setTransparency(node.hasTransparency());
        myNode.setSrs(node.getAllSrs());
        myNode.setQueryable(node.isQueryable() && this.client.getServiceInformation().isQueryable());
        myNode.setParent(parentNode);
        myNode.setAbstract(node.getAbstract());
        myNode.setFixedSize(node.getfixedWidth(), node.getfixedHeight());
        if (node.getLatLonBox() != null) {
            myNode.setLatLonBox(node.getLatLonBox().toString());
        }
        ArrayList keywords = node.getKeywords();
        for (int i = 0; i < keywords.size(); ++i) {
            myNode.addKeyword((String)keywords.get(i));
        }
        ArrayList styles = node.getStyles();
        for (int i = 0; i < styles.size(); ++i) {
            WMSStyle style = (WMSStyle)styles.get(i);
            myNode.addStyle(style);
        }
        ArrayList dimensions = node.getDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            WMSDimension d = (WMSDimension)dimensions.get(i);
            myNode.addDimension(d.getName(), d.getUnits(), d.getUnitSymbol(), d.getDimensionExpression());
        }
        int children = node.getChildren().size();
        myNode.setChildren(new ArrayList<WMSLayerNode>());
        for (int i = 0; i < children; ++i) {
            myNode.getChildren().add(this.parseTree((WMSLayer)node.getChildren().get(i), myNode));
        }
        if (myNode.getName() != null) {
            this.layers.put(myNode.getName(), myNode);
        }
        return myNode;
    }

    public Rectangle2D getRectangleFromBoundaryBox(BoundaryBox bbox) {
        return new Rectangle2D.Double(bbox.getXmin(), bbox.getYmin(), Math.abs(bbox.getXmax() - bbox.getXmin()), Math.abs(bbox.getYmax() - bbox.getYmin()));
    }

    public BoundaryBox getBoundaryBoxFromRectangle(Rectangle2D r) {
        BoundaryBox bbox = new BoundaryBox();
        bbox.setXmin(r.getMinX());
        bbox.setXmax(r.getMaxX());
        bbox.setYmin(r.getMinY());
        bbox.setYmax(r.getMaxY());
        return bbox;
    }

    public String getAbstract() {
        return this.client.getServiceInformation().abstr;
    }

    public Rectangle2D getLayersExtent(String[] layerName, String srs) {
        return this.client.getLayersExtent(layerName, srs);
    }

    public WMSLayerNode getLayer(String layerName) {
        if (this.getLayers().get(layerName) != null) {
            return this.layers.get(layerName);
        }
        return null;
    }

    private TreeMap getLayers() {
        if (this.fmapRootLayer == null) {
            this.fmapRootLayer = this.getLayersTree();
        }
        return this.layers;
    }

    public String getFeatureInfo(WMSStatus _wmsStatus, int i, int j, int max_value, ICancellable cancellable) throws RemoteServiceException {
        try {
            return this.client.getFeatureInfo(_wmsStatus, i, j, max_value, cancellable);
        }
        catch (WMSException e) {
            throw new RemoteServiceException();
        }
    }

    public String getHost() {
        return this.client.getHost();
    }
}

