/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSProvider;
import org.gvsig.raster.wms.io.WMSServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class WMSDataParametersImpl
extends AbstractRasterDataParameters
implements WMSDataParameters {
    private static final String FIELD_FORMAT = "format";
    private static final String FIELD_INFOFORMAT = "infoformat";
    public static final String FIELD_LAYERQUERY = "layer_query";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SRSSTR = "srsstr";
    private static final String FIELD_TRANSPARENCY = "transparency";
    private static final String FIELD_INFOLAYERQUERY = "infolayerquery";
    private static final String FIELD_QUERYABLE = "queryable";
    private static final String FIELD_OVERRIDE = "override";
    private static final String FIELD_STYLES = "styles";
    private static final String FIELD_DIMENSIONS = "dimensions";
    private static final String FIELD_ONLINERESOURC = "onlineresources";
    private static final String FIELD_FIXEDSIZE = "fixedsize";
    private static final String FIELD_EXTENT = "extent";
    private static final String FIELD_WIDTH = "width";
    private static final String FIELD_HEIGHT = "height";
    private static final String FIELD_DELETECACHE = "deletecache";
    private static final String FIELD_ASSUMEXYAXISORDER = "assumeXY";
    public static final String DYNFIELDNAME_AUTHENTICATION_CONFIG = "authenticationConfig";
    private DelegatedDynObject delegatedDynObject = null;
    protected static DynClass DYNCLASS = null;
    private ICancellable cancel = null;

    public WMSDataParametersImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(WMSDataParametersImpl.registerDynClass());
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("WMSDataParameters_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(WMSDataParametersImpl.class, "WMSDataParameters_Persistent", "WMS DataParameters Persistency", null, null);
        }
        AbstractRasterDataParameters.registerDynClass((DynStruct)definition);
        definition.addDynFieldObject(FIELD_EXTENT).setDescription("Bounding box").setClassOfValue(Rectangle2D.class).setMandatory(false);
        definition.addDynFieldInt(FIELD_WIDTH).setDescription("Width").setMandatory(false);
        definition.addDynFieldInt(FIELD_HEIGHT).setDescription("Height").setMandatory(false);
        definition.addDynFieldString(FIELD_FORMAT).setDescription("Format").setMandatory(false);
        definition.addDynFieldString(FIELD_INFOFORMAT).setDescription("Info by point format").setMandatory(false);
        definition.addDynFieldString(FIELD_LAYERQUERY).setDescription("Layer Query").setMandatory(false);
        definition.addDynFieldString(FIELD_NAME).setDescription("Name").setMandatory(false);
        definition.addDynFieldString(FIELD_SRSSTR).setDescription("String that represents the SRS").setMandatory(false);
        definition.addDynFieldBoolean(FIELD_TRANSPARENCY).setDescription("Transparency").setMandatory(false);
        definition.addDynFieldString(FIELD_INFOLAYERQUERY).setDescription("InfoLayerQuery").setMandatory(false);
        definition.addDynFieldBoolean(FIELD_QUERYABLE).setDescription("Queryable").setMandatory(false);
        definition.addDynFieldBoolean(FIELD_OVERRIDE).setDescription("Override a host capabilities").setMandatory(false);
        definition.addDynFieldList(FIELD_STYLES).setDescription("Styles").setClassOfItems(RemoteWMSStyle.class).setMandatory(false);
        definition.addDynFieldList(FIELD_DIMENSIONS).setDescription("Dimensions").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldMap(FIELD_ONLINERESOURC).setDescription("online resources").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldObject(FIELD_FIXEDSIZE).setDescription("Fixed size").setClassOfValue(Dimension.class).setMandatory(false);
        definition.addDynFieldBoolean(FIELD_DELETECACHE).setDescription("Flag to delete cache the next request").setMandatory(false);
        definition.addDynFieldBoolean(FIELD_ASSUMEXYAXISORDER).setDescription("Flag to decide the axis order behaviour").setMandatory(false);
        definition.addDynFieldString(DYNFIELDNAME_AUTHENTICATION_CONFIG).setDescription("Authentication config").setMandatory(false);
        return definition;
    }

    @Override
    public String getFormat() {
        return (String)this.getDynValue(FIELD_FORMAT);
    }

    @Override
    public void setFormat(String format) {
        this.setDynValue(FIELD_FORMAT, format);
    }

    @Override
    public String getInfoFormat() {
        String o = (String)this.getDynValue(FIELD_INFOFORMAT);
        if (o == null) {
            return "text/plain";
        }
        return o;
    }

    @Override
    public void setInfoFormat(String format) {
        this.setDynValue(FIELD_INFOFORMAT, format);
    }

    @Override
    public String getLayerQuery() {
        return (String)this.getDynValue(FIELD_LAYERQUERY);
    }

    @Override
    public void setLayerQuery(String layerQuery) {
        this.setDynValue(FIELD_LAYERQUERY, layerQuery);
    }

    @Override
    public String getSRSCode() {
        return (String)this.getDynValue(FIELD_SRSSTR);
    }

    @Override
    public void setSRS(String m_srs) {
        this.setDynValue(FIELD_SRSSTR, m_srs);
        if (m_srs.equals("CRS:84")) {
            m_srs = "EPSG:4326";
        }
        this.setSRS(CRSFactory.getCRS((String)m_srs));
    }

    public void setSRSID(String srsid) {
        if (srsid == null) {
            this.setDynValue(FIELD_SRSSTR, null);
        } else {
            this.setDynValue(FIELD_SRSSTR, CRSFactory.getCRS((String)srsid));
        }
    }

    @Override
    public String getName() {
        return (String)this.getDynValue(FIELD_NAME);
    }

    @Override
    public void setName(String name) {
        this.setDynValue(FIELD_NAME, name);
    }

    @Override
    public boolean isWmsTransparent() {
        Boolean b = (Boolean)this.getDynValue(FIELD_TRANSPARENCY);
        if (b != null) {
            return b;
        }
        return false;
    }

    @Override
    public void setWmsTransparency(boolean wmsTransparency) {
        this.setDynValue(FIELD_TRANSPARENCY, wmsTransparency);
    }

    @Override
    public String getInfoLayerQuery() {
        return (String)this.getDynValue(FIELD_INFOLAYERQUERY);
    }

    @Override
    public void setInfoLayerQuery(String infoLayerQuery) {
        this.setDynValue(FIELD_INFOLAYERQUERY, infoLayerQuery);
    }

    @Override
    public void setQueryable(boolean b) {
        this.setDynValue(FIELD_QUERYABLE, b);
    }

    @Override
    public void setCancellable(ICancellable cancel) {
        this.cancel = cancel;
    }

    @Override
    public ICancellable getCancellable() {
        return this.cancel;
    }

    @Override
    public boolean isQueryable() {
        Boolean b = (Boolean)this.getDynValue(FIELD_QUERYABLE);
        if (b != null) {
            return b;
        }
        return false;
    }

    public boolean isOverridingHost() {
        Boolean b = (Boolean)this.getDynValue(FIELD_OVERRIDE);
        if (b != null) {
            return b;
        }
        return false;
    }

    @Override
    public void setOverrideHost(boolean over) {
        this.setDynValue(FIELD_OVERRIDE, over);
    }

    @Override
    public void setStyles(List<RemoteWMSStyle> styles) {
        this.setDynValue(FIELD_STYLES, styles);
    }

    @Override
    public List<RemoteWMSStyle> getStyles() {
        return (List)this.getDynValue(FIELD_STYLES);
    }

    @Override
    public void setDimensions(Vector<String> dimensions) {
        this.setDynValue(FIELD_DIMENSIONS, dimensions);
    }

    @Override
    public Vector<String> getDimensions() {
        return (Vector)this.getDynValue(FIELD_DIMENSIONS);
    }

    @Override
    public void setOnlineResources(Map<String, String> onlineResources) {
        this.setDynValue(FIELD_ONLINERESOURC, onlineResources);
    }

    @Override
    public String getOnlineResource(String operation) {
        return this.getOnlineResource().get(operation);
    }

    @Override
    public Map<String, String> getOnlineResource() {
        return (Map)this.getDynValue(FIELD_ONLINERESOURC);
    }

    @Override
    public void setFixedSize(Dimension sz) {
        this.setDynValue(FIELD_FIXEDSIZE, sz);
    }

    public boolean isSizeFixed() {
        return this.getDynValue(FIELD_FIXEDSIZE) != null;
    }

    @Override
    public Dimension getFixedSize() {
        return (Dimension)this.getDynValue(FIELD_FIXEDSIZE);
    }

    @Override
    public void setExtent(Rectangle2D bBox) {
        this.setDynValue(FIELD_EXTENT, bBox);
    }

    public void setWidth(int w) {
        this.setDynValue(FIELD_WIDTH, w);
    }

    public void setHeight(int h) {
        this.setDynValue(FIELD_HEIGHT, h);
    }

    @Override
    public Rectangle2D getExtent() {
        return (Rectangle2D)this.getDynValue(FIELD_EXTENT);
    }

    @Override
    public int getWidth() {
        Integer b = (Integer)this.getDynValue(FIELD_WIDTH);
        if (b != null) {
            return b;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        Integer b = (Integer)this.getDynValue(FIELD_HEIGHT);
        if (b != null) {
            return b;
        }
        return 0;
    }

    public String getDataStoreName() {
        return WMSProvider.NAME;
    }

    public String getDescription() {
        return WMSProvider.DESCRIPTION;
    }

    public String getExplorerName() {
        return WMSServerExplorer.NAME;
    }

    public boolean isValid() {
        return this.getURI() != null;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    public void deleteCache(boolean deleteCache) {
        this.setDynValue(FIELD_DELETECACHE, deleteCache);
    }

    public boolean isDeletingCache() {
        return (Boolean)this.getDynValue(FIELD_DELETECACHE);
    }

    public WMSDataParameters clone() {
        WMSDataParametersImpl p = new WMSDataParametersImpl();
        p.setFormat(this.getFormat());
        p.setFixedSize(this.getFixedSize());
        p.setHeight(this.getHeight());
        p.setWidth(this.getWidth());
        p.setExtent(this.getExtent());
        p.setURI(this.getURI());
        p.setInfoLayerQuery(this.getInfoLayerQuery());
        p.setLayerQuery(this.getLayerQuery());
        p.setName(this.getName());
        p.setOnlineResources((Hashtable)this.getDynValue(FIELD_ONLINERESOURC));
        p.setOverrideHost(this.isOverridingHost());
        p.setQueryable(this.isQueryable());
        p.setSRS(this.getSRS());
        p.setSRS(this.getSRSCode());
        p.setStyles(this.getStyles());
        p.setWmsTransparency(this.isWmsTransparent());
        p.setDimensions(this.getDimensions());
        p.setCancellable(this.getCancellable());
        p.setXyAxisOrder(this.isXyAxisOrder());
        return p;
    }

    public void assignFields(RasterDataParameters par, RasterDataServerExplorer explorer) {
        super.assignFields(par, explorer);
        if (!(par instanceof WMSDataParametersImpl)) {
            return;
        }
        WMSDataParametersImpl p = (WMSDataParametersImpl)par;
        this.setFormat(p.getFormat());
        this.setFixedSize(p.getFixedSize());
        this.setHeight(p.getHeight());
        this.setWidth(p.getWidth());
        this.setExtent(p.getExtent());
        this.setURI(p.getURI());
        this.setInfoLayerQuery(p.getInfoLayerQuery());
        this.setLayerQuery(p.getLayerQuery());
        this.setName(this.getName());
        this.setOnlineResources((Map)p.getDynValue(FIELD_ONLINERESOURC));
        this.setOverrideHost(p.isOverridingHost());
        this.setQueryable(p.isQueryable());
        this.setSRS(p.getSRSCode());
        this.setStyles(p.getStyles());
        this.setWmsTransparency(p.isWmsTransparent());
        this.setDimensions(p.getDimensions());
        this.setCancellable(p.getCancellable());
        this.setXyAxisOrder(p.isXyAxisOrder());
    }

    @Override
    public boolean isXyAxisOrder() {
        Boolean b = (Boolean)this.getDynValue(FIELD_ASSUMEXYAXISORDER);
        if (b != null) {
            return b;
        }
        return false;
    }

    @Override
    public void setXyAxisOrder(boolean assumeXY) {
        this.setDynValue(FIELD_ASSUMEXYAXISORDER, assumeXY);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        this.setDynValue(DYNFIELDNAME_AUTHENTICATION_CONFIG, downloader.getAuthenticationConfigurationServiceAsString(this.getURI().toString()));
        super.saveToState(state);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        downloader.registerAuthenticationConfigurationService((String)this.getDynValue(DYNFIELDNAME_AUTHENTICATION_CONFIG));
    }
}

