/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io.time;

import org.gvsig.raster.wms.io.time.RemoteTimeDimension;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultDimension
implements RemoteTimeDimension {
    private static final String digit = "[0-9]";
    private static final String nonZeroDigit = "[1-9]";
    private static final String letter = "[_$%a-zA-Z]";
    private static final String word = "[_$%a-zA-Z]([_$%a-zA-Z]|[0-9])+";
    private static final String floatingPointNumber = "([0-9]+(\\.[0-9]+)?)";
    private static final String integerNumber = "[1-9][0-9]+";
    private static final String dimensionItem = "(([0-9]+(\\.[0-9]+)?)|[_$%a-zA-Z]([_$%a-zA-Z]|[0-9])+)";
    private static final String regexpDefaultDimensionExpression = "(([0-9]+(\\.[0-9]+)?)/([0-9]+(\\.[0-9]+)?)/([0-9]+(\\.[0-9]+)?)|(([0-9]+(\\.[0-9]+)?)|[_$%a-zA-Z]([_$%a-zA-Z]|[0-9])+)(,(([0-9]+(\\.[0-9]+)?)|[_$%a-zA-Z]([_$%a-zA-Z]|[0-9])+))*)";
    private String name;
    private String unit;
    private String unitSymbol;
    private String expression;
    private String period;
    private Object minValue;
    private Object maxValue;
    private int type;
    private boolean compiled = false;

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.name = state.getString("name");
        this.unit = state.getString("unit");
        this.unitSymbol = state.getString("unitSymbol");
        this.expression = state.getString("expression");
        this.period = state.getString("period");
        this.minValue = state.getString("minValue");
        this.maxValue = state.getString("maxValue");
        this.type = state.getInt("type");
        this.compiled = state.getBoolean("compiled");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("name", this.name);
        state.set("unit", this.unit);
        state.set("unitSymbol", this.unitSymbol);
        state.set("expression", this.expression);
        state.set("period", this.period);
        state.set("minValue", this.minValue);
        state.set("maxValue", this.maxValue);
        state.set("type", this.type);
        state.set("compiled", this.compiled);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("DefaultDimension_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(DefaultDimension.class, "DefaultDimension_Persistent", "DefaultDimension Persistence", null, null);
        }
        definition.addDynFieldString("name").setMandatory(false);
        definition.addDynFieldString("unit").setMandatory(false);
        definition.addDynFieldString("unitSymbol").setMandatory(false);
        definition.addDynFieldString("expression").setMandatory(false);
        definition.addDynFieldString("period").setMandatory(false);
        definition.addDynFieldString("minValue").setMandatory(false);
        definition.addDynFieldString("maxValue").setMandatory(false);
        definition.addDynFieldInt("type").setMandatory(false);
        definition.addDynFieldBoolean("compiled").setMandatory(false);
    }

    public DefaultDimension() {
    }

    public DefaultDimension(String _name, String _units, String _unitSymbol, String _dimensionExpression) {
        this.name = _name;
        this.unit = _units;
        this.unitSymbol = _unitSymbol;
        this.setExpression(_dimensionExpression);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public String getUnitSymbol() {
        return this.unitSymbol;
    }

    @Override
    public String getLowLimit() {
        return (String)this.minValue;
    }

    @Override
    public String getHighLimit() {
        return (String)this.maxValue;
    }

    @Override
    public String getResolution() {
        if (this.type == 2) {
            String[] s = this.expression.split("/");
            return s.length == 1 ? s[3] : null;
        }
        return null;
    }

    @Override
    public boolean isValidValue(String value) {
        return value.matches(word) || value.matches(floatingPointNumber);
    }

    @Override
    public Object valueOf(String value) throws IllegalArgumentException {
        if (this.compiled) {
            if (value.matches(word)) {
                return value;
            }
            if (value.matches(integerNumber)) {
                return new Integer(value);
            }
            if (value.matches(floatingPointNumber)) {
                return new Float(value);
            }
        }
        return null;
    }

    @Override
    public String valueAt(int pos) throws ArrayIndexOutOfBoundsException {
        if (this.compiled) {
            if (pos < 0 || pos > this.valueCount()) {
                throw new ArrayIndexOutOfBoundsException(pos + "(must be >= 0 and <=" + this.valueCount() + ")");
            }
            if (this.type == 0) {
                return this.expression;
            }
            if (this.type == 1) {
                return this.expression.split(",")[pos];
            }
            if (this.type == 2) {
                double minPos = Double.parseDouble((String)this.minValue);
                double maxPos = Double.parseDouble((String)this.maxValue);
                double step = Double.parseDouble(this.period);
                double newPos = minPos + step * (double)pos;
                if (newPos < minPos) {
                    return minPos + "";
                }
                if (newPos > maxPos) {
                    return maxPos + "";
                }
                return newPos + "";
            }
        }
        return null;
    }

    @Override
    public int valueCount() {
        if (this.compiled) {
            if (this.type == 1) {
                return this.expression.split(",").length;
            }
            if (this.type == 2) {
                double min = Double.parseDouble((String)this.minValue);
                double max = Double.parseDouble((String)this.maxValue);
                double step = Double.parseDouble(this.period);
                double distance = max - min;
                int count = (int)(distance / step);
                return count;
            }
            return 1;
        }
        return -1;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String expr) {
        this.expression = expr.toUpperCase();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void compile() throws IllegalArgumentException {
        String separator;
        if (!this.expression.matches(regexpDefaultDimensionExpression)) {
            throw new IllegalArgumentException();
        }
        if (this.expression.indexOf("/") != -1) {
            separator = "/";
            this.type = 2;
        } else if (this.expression.indexOf(",") != -1) {
            separator = ",";
            this.type = 1;
        } else {
            separator = ",";
            this.type = 0;
        }
        this.compiled = true;
        String[] s = this.expression.split(separator);
        this.minValue = this.valueOf(s[0]);
        if (this.type == 2) {
            this.maxValue = s.length > 1 ? this.valueOf(s[1]) : this.valueOf(s[0]);
            this.period = s.length > 2 ? s[2] : null;
        } else {
            this.maxValue = this.type == 1 ? this.valueOf(s[s.length - 1]) : this.valueOf(s[0]);
        }
    }
}

