/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.base.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.gvsig.geoprocess.lib.api.GeoProcess;
import org.gvsig.geoprocess.lib.api.GeoProcessLibrary;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.tools.library.AbstractLibrary;

public abstract class AlgorithmAbstractLibrary
extends AbstractLibrary {
    protected HashMap<String, String> text = new HashMap();

    public void doRegistration() {
        this.registerAsServiceOf(GeoProcessLibrary.class);
    }

    protected void setLanguageStrings(String algorithmName) {
        this.text = new HashMap<String, String>(this.getLanguageStrings(algorithmName));
    }

    protected Map<String, String> getLanguageStrings(String algorithmName) {
        HashMap<String, String> text = new HashMap<String, String>();
        String defaultFile = algorithmName;
        String file = algorithmName + "_" + Locale.getDefault().getLanguage();
        ResourceBundle labels = null;
        try {
            labels = ResourceBundle.getBundle(file, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            file = defaultFile;
        }
        try {
            if (labels == null) {
                labels = ResourceBundle.getBundle(file, Locale.getDefault());
            }
            Enumeration<String> bundleKeys = labels.getKeys();
            while (bundleKeys.hasMoreElements()) {
                String key = bundleKeys.nextElement();
                String value = labels.getString(key);
                text.put(key, value);
            }
        }
        catch (MissingResourceException e) {
            file = defaultFile;
        }
        return text;
    }

    protected void registerGeoProcess(GeoProcess geoProcess) {
        GeoProcessLocator.getGeoProcessManager().registerGeoProcess(geoProcess);
    }

    protected void registerGeoProcess(Class<? extends GeoProcess> geoProcessClazz, Map<String, String> localeStrings) {
        GeoProcessLocator.getGeoProcessManager().registerGeoProcess(geoProcessClazz, localeStrings);
    }
}

