/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.lib.impl;

import Jama.Matrix;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.georeferencing.lib.impl.GeoTransformDataResult;

public class GeoTransformProcess
extends DataProcess {
    public static String GCPS = "gcps";
    public static String ORDER = "Order";
    public static String RESULT = "RESULT";
    private GeoPointList gcps = null;
    protected int orden = 0;
    protected int minGPC = 0;
    private int[][] exp = null;
    private double rmsXTotal = 0.0;
    private double rmsYTotal = 0.0;
    private double rmsTotal = 0.0;
    GeoTransformDataResult resultData = null;
    private double[] mapToPixelCoefX = null;
    private double[] mapToPixelCoefY = null;
    private double[] pixelToMapCoefX = null;
    private double[] pixelToMapCoefY = null;

    public static void registerParameters() {
        GeoTransformProcess.registerInputParameter((String)GCPS, GeoPointList.class, (String)"GeotransformProcess");
        GeoTransformProcess.registerInputParameter((String)ORDER, Integer.class, (String)"GeotransformProcess");
        GeoTransformProcess.registerOutputParameter((String)RESULT, GeoTransformDataResult.class, (String)"GeotransformProcess");
    }

    public void init() {
        this.gcps = this.getParam(GCPS) != null ? (GeoPointList)this.getParam(GCPS) : null;
        this.orden = this.getIntParam(ORDER);
        this.orden = Math.max(1, this.orden);
        this.minGPC = (this.orden + 1) * (this.orden + 2) / 2;
        this.exp = new int[this.minGPC][2];
        this.resetErrors();
        this.resultData = new GeoTransformDataResult();
        if (!this.enoughPoints()) {
            this.minGPC = 0;
        }
    }

    private void resetErrors() {
        for (int i = 0; i < this.gcps.size(); ++i) {
            ((GeoPoint)this.gcps.get(i)).resetErrors();
        }
    }

    public boolean enoughPoints() {
        int countActives = 0;
        for (int i = 0; i < this.gcps.size(); ++i) {
            if (!((GeoPoint)this.gcps.get(i)).isActive()) continue;
            ++countActives;
        }
        return countActives >= this.minGPC;
    }

    public void process() {
        if (this.minGPC > 0) {
            this.calculatePolinomialCoefs();
            this.calculateRMSerror();
            this.resultData.setGpcs(this.gcps);
            this.resultData.setPixelToMapCoefX(this.pixelToMapCoefX);
            this.resultData.setPixelToMapCoefY(this.pixelToMapCoefY);
            this.resultData.setMapToPixelCoefX(this.mapToPixelCoefX);
            this.resultData.setMapToPixelCoefY(this.mapToPixelCoefY);
            this.resultData.setRmsXTotal(this.rmsXTotal);
            this.resultData.setRmsYTotal(this.rmsYTotal);
            this.resultData.setRmsTotal(this.rmsTotal);
            this.resultData.setPolynomialOrden(this.orden);
            this.resultData.setExp(this.exp);
            this.addOutputValue(RESULT, this.resultData);
            return;
        }
        this.resultData = null;
    }

    public void calculatePolinomialCoefs() {
        double[][] matrixD = new double[this.minGPC][this.minGPC];
        double[][] matrixD2 = new double[this.minGPC][this.minGPC];
        double[] columResult = new double[this.minGPC];
        double[] columResult2 = new double[this.minGPC];
        double[] columResult3 = new double[this.minGPC];
        double[] columResult4 = new double[this.minGPC];
        int k = -1;
        for (int filas = 0; filas < this.minGPC; ++filas) {
            k = -1;
            for (int i = 0; i <= this.orden; ++i) {
                for (int j = 0; j <= i; ++j) {
                    GeoPoint point;
                    int v;
                    ++k;
                    for (v = 0; v < this.gcps.size(); ++v) {
                        point = (GeoPoint)this.gcps.get(v);
                        if (!point.isActive()) continue;
                        double[] dArray = matrixD[filas];
                        int n = k;
                        dArray[n] = dArray[n] + Math.pow(point.getPixelPoint().getX(), i - j) * Math.pow(point.getPixelPoint().getX(), this.exp[filas][0]) * (Math.pow(point.getPixelPoint().getY(), j) * Math.pow(point.getPixelPoint().getY(), this.exp[filas][1]));
                        double[] dArray2 = matrixD2[filas];
                        int n2 = k;
                        dArray2[n2] = dArray2[n2] + Math.pow(point.getMapPoint().getX(), i - j) * Math.pow(point.getMapPoint().getX(), this.exp[filas][0]) * (Math.pow(point.getMapPoint().getY(), j) * Math.pow(point.getMapPoint().getY(), this.exp[filas][1]));
                    }
                    if (filas != 0) continue;
                    this.exp[k][0] = i - j;
                    this.exp[k][1] = j;
                    for (v = 0; v < this.gcps.size(); ++v) {
                        point = (GeoPoint)this.gcps.get(v);
                        if (!point.isActive()) continue;
                        int n = k;
                        columResult[n] = columResult[n] + Math.pow(point.getPixelPoint().getX(), i - j) * Math.pow(point.getPixelPoint().getX(), this.exp[filas][0]) * (Math.pow(point.getPixelPoint().getY(), j) * Math.pow(point.getPixelPoint().getY(), this.exp[filas][1])) * point.getMapPoint().getY();
                        int n3 = k;
                        columResult2[n3] = columResult2[n3] + Math.pow(point.getMapPoint().getX(), i - j) * Math.pow(point.getMapPoint().getX(), this.exp[filas][0]) * (Math.pow(point.getMapPoint().getY(), j) * Math.pow(point.getMapPoint().getY(), this.exp[filas][1])) * point.getPixelPoint().getY();
                        int n4 = k;
                        columResult3[n4] = columResult3[n4] + Math.pow(point.getPixelPoint().getX(), i - j) * Math.pow(point.getPixelPoint().getX(), this.exp[filas][0]) * (Math.pow(point.getPixelPoint().getY(), j) * Math.pow(point.getPixelPoint().getY(), this.exp[filas][1])) * point.getMapPoint().getX();
                        int n5 = k;
                        columResult4[n5] = columResult4[n5] + Math.pow(point.getMapPoint().getX(), i - j) * Math.pow(point.getMapPoint().getX(), this.exp[filas][0]) * (Math.pow(point.getMapPoint().getY(), j) * Math.pow(point.getMapPoint().getY(), this.exp[filas][1])) * point.getPixelPoint().getX();
                    }
                }
            }
        }
        Matrix matrixResult = new Matrix(matrixD);
        Matrix matrixResult2 = new Matrix(matrixD2);
        this.pixelToMapCoefY = this.solveSystem(matrixResult, columResult);
        this.mapToPixelCoefY = this.solveSystem(matrixResult2, columResult2);
        this.pixelToMapCoefX = this.solveSystem(matrixResult, columResult3);
        this.mapToPixelCoefX = this.solveSystem(matrixResult2, columResult4);
    }

    public double[] solveSystem(Matrix matrix, double[] columResult) {
        double[] xCoef = new double[this.minGPC];
        double[][] a = new double[columResult.length][1];
        for (int i = 0; i < columResult.length; ++i) {
            a[i][0] = columResult[i];
        }
        Matrix c = null;
        if (matrix.det() == 0.0) {
            flanagan.math.Matrix matrixFL = new flanagan.math.Matrix(matrix.getArray());
            xCoef = matrixFL.solveLinearSet(columResult);
        } else {
            c = matrix.solve(new Matrix(a));
            for (int i = 0; i < columResult.length; ++i) {
                xCoef[i] = c.get(i, 0);
            }
        }
        return xCoef;
    }

    public void calculateRMSerror() {
        int numgpcs = this.gcps.size();
        double rmsxTotal = 0.0;
        double rmsyTotal = 0.0;
        this.rmsTotal = 0.0;
        int num = 0;
        for (int im_point = 0; im_point < numgpcs; ++im_point) {
            GeoPoint point = (GeoPoint)this.gcps.get(im_point);
            if (!point.isActive()) continue;
            double[] tmp = this.getCoordMap(point.getPixelPoint().getX(), point.getPixelPoint().getY());
            double[] tmp2 = this.getCoordPixel(tmp[0], tmp[1]);
            point.setEvaluateX(tmp2[0]);
            point.setEvaluateY(tmp2[1]);
            point.setErrorX(Math.pow(point.getEvaluateX() - point.getPixelPoint().getX(), 2.0));
            rmsxTotal += point.getErrorX();
            point.setErrorY(Math.pow(point.getEvaluateY() - point.getPixelPoint().getY(), 2.0));
            rmsyTotal += point.getErrorY();
            point.setRms(Math.sqrt(point.getErrorX() + point.getErrorY()));
            this.rmsTotal += point.getRms();
            ++num;
        }
        this.rmsTotal = Math.sqrt(this.rmsTotal / (double)num);
        this.rmsXTotal = Math.sqrt(rmsxTotal / (double)num);
        this.rmsYTotal = Math.sqrt(rmsyTotal / (double)num);
    }

    public double getRMSx() {
        return this.rmsXTotal;
    }

    public double getRMSy() {
        return this.rmsYTotal;
    }

    public double getRMSTotal() {
        return this.rmsTotal;
    }

    public String getTitle() {
        return Messages.getText((String)"transformacion");
    }

    public String getLog() {
        return Messages.getText((String)"calculando_transformacion");
    }

    public double[] getCoordMap(double x, double y) {
        double[] eval = new double[2];
        for (int i = 0; i < this.pixelToMapCoefX.length; ++i) {
            eval[0] = eval[0] + this.pixelToMapCoefX[i] * Math.pow(x, this.exp[i][0]) * Math.pow(y, this.exp[i][1]);
            eval[1] = eval[1] + this.pixelToMapCoefY[i] * Math.pow(x, this.exp[i][0]) * Math.pow(y, this.exp[i][1]);
        }
        return eval;
    }

    public double[] getCoordPixel(double x, double y) {
        double[] eval = new double[2];
        for (int i = 0; i < this.pixelToMapCoefX.length; ++i) {
            eval[0] = eval[0] + this.mapToPixelCoefX[i] * Math.pow(x, this.exp[i][0]) * Math.pow(y, this.exp[i][1]);
            eval[1] = eval[1] + this.mapToPixelCoefY[i] * Math.pow(x, this.exp[i][0]) * Math.pow(y, this.exp[i][1]);
        }
        return eval;
    }
}

