/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.border;

import com.jeta.forms.gui.effects.LinearGradientPainter;
import com.jeta.forms.gui.effects.RadialGradientPainter;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.ShadowBorderProperty;
import com.jeta.forms.store.properties.effects.GradientProperty;
import com.jeta.forms.store.properties.effects.RadialGradientProperty;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;

public class ShadowBorder
implements Border {
    private ShadowBorderProperty m_prop;
    private Insets m_insets;
    private LinearGradientPainter m_right_painter;
    private LinearGradientPainter m_bottom_painter;
    private RadialGradientPainter m_bottom_right_painter;
    private RadialGradientPainter m_top_right_painter;
    private RadialGradientPainter m_bottom_left_painter;
    private Rectangle m_rect;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ShadowBorder() {
    }

    public ShadowBorder(int type, int thickness, ColorProperty startColor, ColorProperty endColor, boolean symmetric) {
        this.m_prop = new ShadowBorderProperty(type, thickness, startColor, endColor, symmetric);
        this.getBorderInsets(null);
    }

    public ShadowBorder(ShadowBorderProperty prop) {
        this.m_prop = new ShadowBorderProperty();
        this.m_prop.setValue(prop);
        this.getBorderInsets(null);
    }

    public Insets getBorderInsets(Component c) {
        if (!$assertionsDisabled && this.m_prop == null) {
            throw new AssertionError();
        }
        if (this.m_insets == null) {
            this.m_insets = this.isSymmetric() ? new Insets(this.m_prop.getThickness(), this.m_prop.getThickness(), this.m_prop.getThickness(), this.m_prop.getThickness()) : new Insets(0, 0, this.m_prop.getThickness(), this.m_prop.getThickness());
        }
        return this.m_insets;
    }

    public boolean isSymmetric() {
        return this.m_prop.isSymmetric();
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public ColorProperty getStartColor() {
        return this.m_prop.getStartColor();
    }

    public ColorProperty getEndColor() {
        return this.m_prop.getEndColor();
    }

    public ShadowBorderProperty getBorderProperty() {
        return this.m_prop;
    }

    public void setBorderProperty(ShadowBorderProperty prop) {
        this.m_prop = prop;
        this.getBorderInsets(null);
        this.m_right_painter = null;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.m_prop.getType() == 0) {
            int thickness = this.m_prop.getThickness();
            int rheight_offset = 0;
            int bwidth_offset = 0;
            if (thickness < 8) {
                rheight_offset = 1;
                bwidth_offset = 1;
            }
            if (this.isSymmetric()) {
                g.setColor(this.m_prop.getEndColor().getColor());
                rheight_offset += thickness;
                bwidth_offset += thickness;
                g.fillRect(x, y, width + thickness, thickness);
                g.fillRect(x, y, thickness, height + thickness);
            }
            g.setColor(this.m_prop.getEndColor().getColor());
            g.fillRect(x + width - thickness, y, thickness, thickness + rheight_offset);
            g.fillRect(x, y + height - thickness, thickness + bwidth_offset, thickness);
            g.setColor(this.m_prop.getStartColor().getColor());
            g.fillRect(x + width - thickness, y + thickness + rheight_offset, thickness, height);
            g.fillRect(x + thickness + bwidth_offset, y + height - thickness, width, thickness);
        } else {
            this.paintGradient(g, x, y, width, height);
        }
    }

    public void paintGradient(Graphics g, int x, int y, int width, int height) {
        if (this.m_right_painter == null) {
            this.m_right_painter = new LinearGradientPainter(new GradientProperty(this.getStartColor(), this.getEndColor(), 2));
            this.m_bottom_painter = new LinearGradientPainter(new GradientProperty(this.getStartColor(), this.getEndColor(), 0));
            this.m_bottom_right_painter = new RadialGradientPainter(new RadialGradientProperty(this.getStartColor(), this.getEndColor(), 0, 200));
            this.m_bottom_right_painter.setRadiusType(1);
            this.m_top_right_painter = new RadialGradientPainter(new RadialGradientProperty(this.getStartColor(), this.getEndColor(), 4, 200));
            this.m_top_right_painter.setRadiusType(1);
            this.m_bottom_left_painter = new RadialGradientPainter(new RadialGradientProperty(this.getStartColor(), this.getEndColor(), 2, 200));
            this.m_bottom_left_painter.setRadiusType(2);
        }
        if (this.m_rect == null) {
            this.m_rect = new Rectangle();
        }
        int thickness = this.m_prop.getThickness();
        int padding = 1;
        int rheight_offset = -1 * padding;
        int bwidth_offset = -1 * padding;
        if (this.isSymmetric()) {
            g.setColor(this.m_prop.getEndColor().getColor());
            rheight_offset += thickness;
            bwidth_offset += thickness;
            g.fillRect(x, y, width + thickness, thickness);
            g.fillRect(x, y, thickness, height + thickness);
            padding = 0;
        }
        g.setColor(this.m_prop.getEndColor().getColor());
        g.fillRect(x + width - thickness, y, thickness, thickness + rheight_offset);
        g.fillRect(x, y + height - thickness, thickness + bwidth_offset, thickness);
        this.m_rect.setBounds(x + width - thickness, y + thickness + rheight_offset, thickness + 1, height - thickness * 2 + padding);
        this.m_right_painter.paint(null, g, this.m_rect);
        this.m_rect.setBounds(x + width - thickness, y + thickness + rheight_offset, thickness, thickness);
        this.m_top_right_painter.paint(null, g, this.m_rect);
        this.m_rect.setBounds(x + thickness + bwidth_offset, y + height - thickness, width - thickness * 2 + padding, thickness);
        this.m_bottom_painter.paint(null, g, this.m_rect);
        this.m_rect.setBounds(x + thickness + bwidth_offset, y + height - thickness, thickness, thickness);
        this.m_bottom_left_painter.paint(null, g, this.m_rect);
        this.m_rect.setBounds(x + width - thickness, y + height - thickness, thickness, thickness);
        this.m_bottom_right_painter.paint(null, g, this.m_rect);
    }

    static {
        $assertionsDisabled = !ShadowBorder.class.desiredAssertionStatus();
    }
}

