/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.rotate;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class RotateEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    public static final String KEY_PIVOT_CENTER_ENVELOPE = "_Key_pivot_center_envelope";
    public static final String PIVOT_CENTER_ENVELOPE = "_Pivot_center_envelope";
    public static final String KEY_PIVOT_CENTROID = "_Key_pivot_centroid";
    public static final String PIVOT_CENTROID = "_Pivot_centroid";
    public static final String ROTATE_MODE = "_Rotate_mode";
    public static final String ROTATE_ACTIVE_ANGLE_MODE = "_Rotate_active_angle_mode";
    public static final String ROTATE_TWO_POINTS_MODE = "_Rotate_two_points_mode";
    public static final String ROTATE_THREE_POINTS_MODE = "_Rotate_three_points_mode";
    public static final String KEY_ROTATE_ACTIVE_ANGLE_MODE = "_Key_rotate_active_angle_mode";
    public static final String KEY_ROTATE_TWO_POINTS_MODE = "_Key_rotate_two_points_mode";
    public static final String KEY_ROTATE_THREE_POINTS_MODE = "_Key_rotate_three_points_mode";
    private static final String SEPARATE_ELEMENTS_QUESTION = "_Separate_elements_question";
    private static final String ELEMENT_ROTATION = "_Element_rotation";
    private static final String INDIVIDUALLY = "_Individually";
    private static final String TOGETHER = "_Together";
    private static final String SHORT_YES = "_short_yes";
    private static final String SHORT_NO = "_short_no";
    private static Boolean savedSeparateElements;
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter pivotPointParameter;
    private String center;
    private final EditingServiceParameter modeParameter;
    private final EditingServiceParameter separateElementsParameter;
    private final EditingServiceParameter angleParameter;
    private final EditingServiceParameter firstPointParameter;
    private final EditingServiceParameter secondPointParameter;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private List<Feature> selectedFeatures;

    public RotateEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.selectionParameter = new DefaultEditingServiceParameter("selection", i18nManager.getTranslation("selection"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION}).setAllowNull(false);
        DefaultEditingServiceParameterOptions options = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation(PIVOT_CENTER_ENVELOPE), (Object)PIVOT_CENTER_ENVELOPE, i18nManager.getTranslation(KEY_PIVOT_CENTER_ENVELOPE)).add(i18nManager.getTranslation(PIVOT_CENTROID), (Object)PIVOT_CENTROID, i18nManager.getTranslation(KEY_PIVOT_CENTROID));
        String consoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage("_Pivot_XcolonX_Point", (EditingServiceParameterOptions)options);
        this.pivotPointParameter = new DefaultEditingServiceParameter("_Pivot_point", consoleMsg, (EditingServiceParameterOptions)options, (Object)PIVOT_CENTER_ENVELOPE, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.OPTION});
        DefaultEditingServiceParameterOptions modeOptions = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation(ROTATE_ACTIVE_ANGLE_MODE), (Object)ROTATE_ACTIVE_ANGLE_MODE, i18nManager.getTranslation(KEY_ROTATE_ACTIVE_ANGLE_MODE)).add(i18nManager.getTranslation(ROTATE_TWO_POINTS_MODE), (Object)ROTATE_TWO_POINTS_MODE, i18nManager.getTranslation(KEY_ROTATE_TWO_POINTS_MODE)).add(i18nManager.getTranslation(ROTATE_THREE_POINTS_MODE), (Object)ROTATE_THREE_POINTS_MODE, i18nManager.getTranslation(KEY_ROTATE_THREE_POINTS_MODE));
        String modeConsoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(ROTATE_MODE, (EditingServiceParameterOptions)modeOptions);
        this.modeParameter = new DefaultEditingServiceParameter(ROTATE_MODE, modeConsoleMsg, (EditingServiceParameterOptions)modeOptions, (Object)ROTATE_TWO_POINTS_MODE, false, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION});
        DefaultEditingServiceParameterOptions separateElementsOptions = new DefaultEditingServiceParameterOptions().add(INDIVIDUALLY, (Object)true, i18nManager.getTranslation(SHORT_YES)).add(TOGETHER, (Object)false, i18nManager.getTranslation(SHORT_NO));
        String separateElementsConsoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(SEPARATE_ELEMENTS_QUESTION, (EditingServiceParameterOptions)separateElementsOptions);
        this.separateElementsParameter = new DefaultEditingServiceParameter(ELEMENT_ROTATION, separateElementsConsoleMsg, (EditingServiceParameterOptions)separateElementsOptions, (Object)i18nManager.getTranslation(SHORT_NO), true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
        this.angleParameter = new DefaultEditingServiceParameter("_Angle", i18nManager.getTranslation("_Angle"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE}).setDataType(7).setAllowNull(false);
        this.firstPointParameter = new DefaultEditingServiceParameter("Start_of_rotation", i18nManager.getTranslation("_Start_of_rotation"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION}).setAllowNull(false);
        this.secondPointParameter = new DefaultEditingServiceParameter("_End_of_rotation", i18nManager.getTranslation("_End_of_rotation"), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION}).setAllowNull(false);
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        block34: {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            if (this.values.get(this.modeParameter) == null) {
                return null;
            }
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            ISymbol ruleAxisSymbol = editingProviderManager.getSymbol("rule-axis-symbol");
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subType = editingProviderServices.getSubType(this.featureStore);
                if (CollectionUtils.isEmpty(this.selectedFeatures)) break block34;
                Point p1 = (Point)this.values.get(this.pivotPointParameter);
                Double angle = null;
                if (p1 != null) {
                    drawingStatus.addStatus((Geometry)p1, auxiliaryPointSymbolEditing, "");
                    switch ((String)this.values.get(this.modeParameter)) {
                        case "_Rotate_active_angle_mode": {
                            return drawingStatus;
                        }
                        case "_Rotate_two_points_mode": {
                            Point p3 = (Point)this.values.get(this.secondPointParameter);
                            if (p3 != null) break;
                            angle = GeometryUtils.calculateAngle((Point)((Point)this.values.get(this.pivotPointParameter)), (Point)mousePosition);
                            Line line = geometryManager.createLine(subType);
                            line.addVertex(p1);
                            p3 = geometryManager.createPoint(p1.getX() + p1.distance((Geometry)mousePosition), p1.getY(), subType);
                            line.addVertex(p3);
                            drawingStatus.addStatus((Geometry)line, ruleAxisSymbol, "");
                            Line line2 = geometryManager.createLine(subType);
                            line2.addVertex(p1);
                            line2.addVertex(mousePosition);
                            drawingStatus.addStatus((Geometry)line2, ruleAxisSymbol, "");
                            Double ext = Math.PI * 2 - angle;
                            Arc arc = GeometryUtils.createArc((Point)p1, (double)(p1.distance((Geometry)mousePosition) / 2.0), (double)0.0, (double)angle, (int)0);
                            drawingStatus.addStatus((Geometry)arc, auxiliaryLineSymbolEditing, "");
                            double textDistance = 3.0 * p1.distance((Geometry)mousePosition) / 4.0;
                            Point pointText = geometryManager.createPoint(p1.getX() + textDistance * Math.cos(angle / 2.0), p1.getY() + textDistance * Math.sin(angle / 2.0), subType);
                            ISimpleTextSymbol textSymbol = this.getTextSymbol();
                            drawingStatus.addStatus((Geometry)pointText, (ISymbol)textSymbol, this.degToDms(Math.toDegrees(angle)));
                            break;
                        }
                        case "_Rotate_three_points_mode": {
                            Point p2 = (Point)this.values.get(this.firstPointParameter);
                            Point p3 = (Point)this.values.get(this.secondPointParameter);
                            if (p2 == null) {
                                Line line = geometryManager.createLine(subType);
                                line.addVertex(p1);
                                line.addVertex(mousePosition);
                                drawingStatus.addStatus((Geometry)line, ruleAxisSymbol, "");
                                break;
                            }
                            if (p3 != null) break;
                            angle = GeometryUtils.calculateAngle((Point)((Point)this.values.get(this.pivotPointParameter)), (Point)p2, (Point)mousePosition);
                            double startAngle = GeometryUtils.calculateAngle((Point)((Point)this.values.get(this.pivotPointParameter)), (Point)p2);
                            Line line = geometryManager.createLine(subType);
                            line.addVertex(p1);
                            line.addVertex(p2);
                            drawingStatus.addStatus((Geometry)line, ruleAxisSymbol, "");
                            Line line2 = geometryManager.createLine(subType);
                            line2.addVertex(p1);
                            line2.addVertex(mousePosition);
                            drawingStatus.addStatus((Geometry)line2, ruleAxisSymbol, "");
                            Double ext = Math.PI * 2 - angle;
                            double minDistance = Math.min(p1.distance((Geometry)p2), p1.distance((Geometry)mousePosition));
                            Arc arc = GeometryUtils.createArc((Point)p1, (double)(minDistance / 2.0), (double)GeometryUtils.calculateAngle((Point)p1, (Point)p2), (double)GeometryUtils.calculateAngle((Point)p1, (Point)p2, (Point)mousePosition), (int)subType);
                            drawingStatus.addStatus((Geometry)arc, auxiliaryLineSymbolEditing, "");
                            double textDistance = 3.0 * minDistance / 4.0;
                            Point pointText = geometryManager.createPoint(p1.getX() + textDistance * Math.cos(startAngle + angle / 2.0), p1.getY() + textDistance * Math.sin(startAngle + angle / 2.0), subType);
                            ISimpleTextSymbol textSymbol = this.getTextSymbol();
                            drawingStatus.addStatus((Geometry)pointText, (ISymbol)textSymbol, this.degToDms(Math.toDegrees(angle)));
                        }
                    }
                    if (angle != null) {
                        AffineTransform at;
                        try {
                            at = this.getRotateAffineTransform(p1, angle);
                        }
                        catch (Exception e) {
                            throw new DrawServiceException((Throwable)e);
                        }
                        Boolean separateElements = (Boolean)this.getValue(this.separateElementsParameter);
                        for (Feature feat : this.selectedFeatures) {
                            ISymbol previewSymbol = this.getPreviewSymbol(feat);
                            Geometry transformedGeometry = feat.getDefaultGeometry().cloneGeometry();
                            if (separateElements.booleanValue()) {
                                Point pivot = null;
                                if (this.center == null || PIVOT_CENTER_ENVELOPE.equalsIgnoreCase(this.center)) {
                                    Envelope featEnv = feat.getDefaultEnvelope();
                                    if (!featEnv.isEmpty()) {
                                        pivot = geometryManager.createPoint(featEnv.getCenter(0), featEnv.getCenter(1), subType);
                                    }
                                } else if (PIVOT_CENTROID.equalsIgnoreCase(this.center)) {
                                    pivot = feat.getDefaultGeometry().centroid();
                                }
                                if (pivot != null) {
                                    try {
                                        at = this.getRotateAffineTransform(pivot, angle);
                                    }
                                    catch (Exception e) {
                                        throw new DrawServiceException((Throwable)e);
                                    }
                                }
                            }
                            transformedGeometry.transform(at);
                            ISymbol symbol = null;
                            if (transformedGeometry instanceof Curve || transformedGeometry instanceof MultiCurve) {
                                symbol = lineSymbolEditing;
                            } else if (transformedGeometry instanceof Surface || transformedGeometry instanceof MultiSurface) {
                                symbol = polygonSymbolEditing;
                            } else if (transformedGeometry instanceof Point || transformedGeometry instanceof MultiPoint) {
                                symbol = auxiliaryPointSymbolEditing;
                            }
                            if (transformedGeometry instanceof Aggregate) {
                                int primitivesNumber = ((Aggregate)transformedGeometry).getPrimitivesNumber();
                                for (int i = 0; i < primitivesNumber; ++i) {
                                    drawingStatus.addStatus((Geometry)((Aggregate)transformedGeometry).getPrimitiveAt(i), symbol, "");
                                    drawingStatus.addStatus((Geometry)((Aggregate)transformedGeometry).getPrimitiveAt(i), previewSymbol, "");
                                }
                                continue;
                            }
                            drawingStatus.addStatus(transformedGeometry, symbol, "");
                            drawingStatus.addStatus(transformedGeometry, previewSymbol, "");
                        }
                    }
                }
                return drawingStatus;
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return null;
    }

    private String degToDms(double deg) {
        int m;
        int d = (int)Math.floor(deg);
        double minfloat = (deg - (double)d) * 60.0;
        double secfloat = (minfloat - (double)(m = (int)Math.floor(minfloat))) * 60.0;
        int s = (int)Math.round(secfloat);
        if (s == 60) {
            ++m;
            s = 0;
        }
        if (m == 60) {
            ++d;
            m = 0;
        }
        return "" + d + "\u00b0" + m + "\u2032" + s + "\u2033";
    }

    private AffineTransform getRotateAffineTransform(Point axisP1, Double angle) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(-axisP1.getX(), -axisP1.getY());
        AffineTransform rotate = AffineTransform.getRotateInstance(angle);
        AffineTransform inverseTranslate = AffineTransform.getTranslateInstance(axisP1.getX(), axisP1.getY());
        AffineTransform at = new AffineTransform(translate);
        at.preConcatenate(rotate);
        at.preConcatenate(inverseTranslate);
        return at;
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.modeParameter) == null) {
            return this.modeParameter;
        }
        if (this.values.get(this.pivotPointParameter) == null) {
            return this.pivotPointParameter;
        }
        if (((String)this.values.get(this.modeParameter)).equalsIgnoreCase(ROTATE_ACTIVE_ANGLE_MODE)) {
            if (this.values.get(this.angleParameter) == null) {
                return this.angleParameter;
            }
        } else if (((String)this.values.get(this.modeParameter)).equalsIgnoreCase(ROTATE_TWO_POINTS_MODE)) {
            if (this.values.get(this.secondPointParameter) == null) {
                return this.secondPointParameter;
            }
        } else if (((String)this.values.get(this.modeParameter)).equalsIgnoreCase(ROTATE_THREE_POINTS_MODE)) {
            if (this.values.get(this.firstPointParameter) == null) {
                return this.firstPointParameter;
            }
            if (this.values.get(this.secondPointParameter) == null) {
                return this.secondPointParameter;
            }
        }
        return null;
    }

    public void stop() {
        this.values.clear();
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.selectionParameter) {
            if (!param.isValidValue(value)) {
                throw new InvalidEntryException(null);
            }
            this.values.put(param, value);
            this.selectedFeatures = this.getSelectedFeaturesCopy((FeatureSelection)value);
        } else if (param == this.modeParameter) {
            if (!param.isValidValue(value)) {
                throw new InvalidEntryException(null);
            }
            String rotateMode = (String)param.getOptions2().getValue(value, param.getDefaultValue());
            this.modeParameter.setDefaultValue((Object)rotateMode);
            this.values.put(param, rotateMode);
        } else if (param == this.separateElementsParameter) {
            if (!param.isValidValue(value)) {
                throw new InvalidEntryException(null);
            }
            savedSeparateElements = (Boolean)param.getOptions2().getValue(value, param.getDefaultValue());
            this.values.put(param, savedSeparateElements);
        } else if (param == this.pivotPointParameter) {
            if (!param.isValidValue(value)) {
                this.center = null;
                throw new InvalidEntryException(null);
            }
            if (value == null) {
                value = param.getDefaultValue();
            }
            if (value instanceof Point) {
                this.values.put(param, value);
                this.center = null;
            } else {
                String pivotMode;
                this.center = pivotMode = (String)param.getOptions2().getValue(value, param.getDefaultValue());
                FeatureSelection selected = (FeatureSelection)this.values.get(this.selectionParameter);
                this.values.put(param, this.calculatePivot(selected, pivotMode));
            }
        } else if (param == this.firstPointParameter) {
            if (!param.isValidValue(value)) {
                throw new InvalidEntryException(null);
            }
            if (((Point)value).equals((Point)this.values.get(this.pivotPointParameter))) {
                throw new InvalidEntryException(null);
            }
            this.values.put(param, value);
        } else if (param == this.secondPointParameter) {
            if (!param.isValidValue(value)) {
                throw new InvalidEntryException(null);
            }
            if (((Point)value).equals((Point)this.values.get(this.firstPointParameter)) || ((Point)value).equals((Point)this.values.get(this.pivotPointParameter))) {
                throw new InvalidEntryException(null);
            }
            this.values.put(param, value);
        } else if (param == this.angleParameter) {
            if (!param.isValidValue(value)) {
                throw new InvalidEntryException(null);
            }
            Object v = this.angleParameter.coerceValue(value);
            if ((Double)v == 0.0) {
                throw new InvalidEntryException(null);
            }
            this.values.put(param, v);
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.selectionParameter);
        list.add(this.modeParameter);
        list.add(this.pivotPointParameter);
        list.add(this.separateElementsParameter);
        list.add(this.angleParameter);
        list.add(this.firstPointParameter);
        list.add(this.secondPointParameter);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public void finishAndStore() throws FinishServiceException {
        block26: {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                AffineTransform at;
                int subType = editingProviderServices.getSubType(this.featureStore);
                if (!CollectionUtils.isNotEmpty(this.selectedFeatures)) break block26;
                Point p0 = (Point)this.values.get(this.pivotPointParameter);
                Double angle = null;
                if (this.values.get(this.angleParameter) != null) {
                    angle = Math.toRadians((Double)this.values.get(this.angleParameter));
                }
                switch ((String)this.values.get(this.modeParameter)) {
                    case "_Rotate_active_angle_mode": {
                        break;
                    }
                    case "_Rotate_two_points_mode": {
                        Object p2 = this.values.get(this.secondPointParameter);
                        angle = GeometryUtils.calculateAngle((Point)p0, (Point)((Point)p2));
                        break;
                    }
                    case "_Rotate_three_points_mode": {
                        Point p1 = (Point)this.values.get(this.firstPointParameter);
                        Object p2 = this.values.get(this.secondPointParameter);
                        angle = GeometryUtils.calculateAngle((Point)p0, (Point)p1, (Point)((Point)p2));
                    }
                }
                if (angle == null) break block26;
                Double finalAngle = angle;
                try {
                    at = this.getRotateAffineTransform(p0, finalAngle);
                }
                catch (GeometryOperationException | GeometryOperationNotSupportedException e) {
                    throw new FinishServiceException(e);
                }
                Boolean separateElements = (Boolean)this.getValue(this.separateElementsParameter);
                GeometryManager geometryManager = GeometryLocator.getGeometryManager();
                try {
                    for (Feature feature : this.selectedFeatures) {
                        AffineTransform individualAt = at;
                        Geometry geom = feature.getDefaultGeometry().cloneGeometry();
                        if (separateElements.booleanValue()) {
                            Point pivot = null;
                            if (this.center == null || PIVOT_CENTER_ENVELOPE.equalsIgnoreCase(this.center)) {
                                Envelope featEnv = feature.getDefaultEnvelope();
                                if (!featEnv.isEmpty()) {
                                    pivot = geometryManager.createPoint(featEnv.getCenter(0), featEnv.getCenter(1), subType);
                                }
                            } else if (PIVOT_CENTROID.equalsIgnoreCase(this.center)) {
                                pivot = feature.getDefaultGeometry().centroid();
                            }
                            if (pivot != null) {
                                try {
                                    individualAt = this.getRotateAffineTransform(pivot, finalAngle);
                                }
                                catch (Exception e) {
                                    throw new DrawServiceException((Throwable)e);
                                }
                            }
                        }
                        geom.transform(individualAt);
                        EditableFeature editableFeature = feature.getEditable();
                        editableFeature.setDefaultGeometry(geom);
                        this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
                    }
                }
                catch (BaseException e) {
                    throw new FinishServiceException((Throwable)e);
                }
                this.featureStore.getFeatureSelection().deselectAll();
            }
            catch (DataException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selectionParameter, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.values.put(this.selectionParameter, null);
        this.selectedFeatures = Collections.EMPTY_LIST;
        this.values.put(this.pivotPointParameter, null);
        this.center = null;
        this.values.put(this.angleParameter, null);
        this.values.put(this.firstPointParameter, null);
        this.values.put(this.secondPointParameter, null);
        this.values.put(this.modeParameter, null);
    }

    public String getName() {
        return "modify-rotate";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    public Object getValue(EditingServiceParameter parameter, EditingServiceParameter.TYPE type) {
        if (this.values == null) {
            return null;
        }
        if (parameter == this.pivotPointParameter && type == EditingServiceParameter.TYPE.OPTION) {
            return this.center;
        }
        return this.values != null ? this.values.get(parameter) : null;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }

    private Point calculatePivot(FeatureSelection selection, String mode) throws InvalidEntryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Point pivot = null;
        FeatureSelection selected = (FeatureSelection)this.values.get(this.selectionParameter);
        try {
            int subType = this.getProviderServices().getSubType(this.featureStore);
            if (selected != null && !selected.isEmpty()) {
                if (PIVOT_CENTER_ENVELOPE.equalsIgnoreCase(mode)) {
                    Envelope envelope = geomManager.createEnvelope(subType);
                    for (Feature feature : selected) {
                        Envelope featEnv = feature.getDefaultEnvelope();
                        envelope.add(featEnv);
                    }
                    if (!envelope.isEmpty()) {
                        pivot = geomManager.createPoint(envelope.getCenter(0), envelope.getCenter(1), subType);
                    }
                } else if (PIVOT_CENTROID.equalsIgnoreCase(mode)) {
                    Geometry geometry = null;
                    for (Feature feature : selected) {
                        if (geometry == null) {
                            geometry = feature.getDefaultGeometry().clone();
                            continue;
                        }
                        geometry = geometry.union(feature.getDefaultGeometry().clone());
                    }
                    if (geometry != null) {
                        pivot = geometry.centroid();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidEntryException((Throwable)ex);
        }
        return pivot;
    }
}

