/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.spi;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.vectorediting.lib.api.DrawingStatus;

public class DefaultDrawingStatus
implements DrawingStatus {
    private final List<Geometry> geometries = new ArrayList<Geometry>();
    private final List<DrawingStatus.Status> status = new ArrayList<DrawingStatus.Status>();
    private String info = null;
    private ISymbol previewSymbol;

    public List<Geometry> getGeometries() {
        return this.geometries;
    }

    public Geometry getGeometry() {
        for (DrawingStatus.Status st : this.status) {
            if (st.getType() != 0) continue;
            return st.getGeometry();
        }
        return null;
    }

    public List<DrawingStatus.Status> getStatus() {
        return this.status;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    public void addGeometry(Geometry geometry) {
        this.geometries.add(geometry);
        this.status.add(new DefaultStatus(geometry, null, null, 1));
    }

    public void addStatus(Geometry geometry, ISymbol symbol, String text) {
        this.addStatus(geometry, symbol, text, 1);
    }

    public void addStatus(Geometry geometry, ISymbol symbol, String text, int type) {
        this.geometries.add(geometry);
        this.status.add(new DefaultStatus(geometry, symbol, text, type));
    }

    public ISymbol getPreviewSymbol() {
        return this.previewSymbol;
    }

    public void setPreviewSymbol(ISymbol previewSymbol) {
        this.previewSymbol = previewSymbol;
    }

    private static class DefaultStatus
    implements DrawingStatus.Status {
        private final Geometry geometry;
        private final ISymbol symbol;
        private final String text;
        private final int type;

        DefaultStatus(Geometry geometry, ISymbol symbol, String text, int type) {
            this.geometry = geometry;
            this.symbol = symbol;
            this.text = text;
            this.type = type;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public ISymbol getSymbol() {
            return this.symbol;
        }

        public String getText() {
            return this.text;
        }

        public int getType() {
            return this.type;
        }
    }
}

