/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.i18n.extension;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.i18n.Messages;
import org.gvsig.i18n.impl.TranslationsConsolider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsolideTranslationsExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(ConsolideTranslationsExtension.class);
    private boolean executing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(String actionCommand) {
        final MainFrame main = PluginServices.getMainFrame();
        if ("tools-devel-consolidate-translations".equalsIgnoreCase(actionCommand)) {
            if (this.executing) {
                main.messageDialog("Process is running.", "Warning", 1);
                return;
            }
            this.executing = true;
            main.refreshControls();
            Thread process = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TranslationsConsolider consolider = new TranslationsConsolider();
                        consolider.consolide();
                        main.messageDialog("Consolidation of translations terminated.", "Information", 1);
                    }
                    catch (Exception ex) {
                        logger.warn("There was errors consolidating translations.", (Throwable)ex);
                        main.messageDialog("There was errors consolidating translations.", "Warning", 2);
                    }
                    finally {
                        ConsolideTranslationsExtension.this.executing = false;
                        main.refreshControls();
                    }
                }
            });
            process.start();
        } else if ("tools-devel-not-translated-keys".equalsIgnoreCase(actionCommand)) {
            PluginsManager pluginsManager = PluginsLocator.getManager();
            File folder = new File(pluginsManager.getApplicationI18nFolder(), "translations.all");
            List notTranslatedKeys = Messages.getNotTranslatedKeys();
            Properties properties = new Properties();
            for (int i = 0; i < notTranslatedKeys.size(); ++i) {
                String key = (String)notTranslatedKeys.get(i);
                properties.put(key, "");
            }
            FileOutputStream fos = null;
            File f = new File(folder, "nottranslated.properties");
            try {
                FileUtils.forceMkdir((File)folder);
                fos = new FileOutputStream(f);
                properties.store(fos, null);
            }
            catch (Exception ex) {
                try {
                    logger.warn("Can't write properties '" + f.getAbsolutePath() + "'.", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    public void initialize() {
    }

    public boolean isEnabled() {
        return !this.executing;
    }

    public boolean isVisible() {
        return true;
    }
}

