/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.PrettyFormatter;

public class PrettyFormaterImpl
implements PrettyFormatter {
    private Stack<PrettyFormaterConfig> config = new Stack();

    public PrettyFormaterImpl() {
        this.config.push(new PrettyFormaterConfig());
    }

    @Override
    public void setIndentSize(int indentSize) {
        PrettyFormaterConfig c = this.config.peek();
        c.indentSize = indentSize;
    }

    @Override
    public void setUseNl(boolean useNl) {
        PrettyFormaterConfig c = this.config.peek();
        c.useNl = useNl;
    }

    @Override
    public void indent() {
        PrettyFormaterConfig c = this.config.peek();
        c.indentation += 4;
    }

    @Override
    public void unindent() {
        PrettyFormaterConfig c = this.config.peek();
        c.indentation -= 4;
        if (c.indentation < 0) {
            c.indentation = 0;
        }
    }

    @Override
    public void nl() {
        PrettyFormaterConfig c = this.config.peek();
        if (c.useNl) {
            c.builder().append("\n");
            c.builder().append(StringUtils.repeat((char)' ', (int)c.indentation));
        }
    }

    @Override
    public void push() {
        PrettyFormaterConfig c = this.config.peek();
        this.config.push(new PrettyFormaterConfig(c.indentation, c.useNl));
    }

    @Override
    public void pop() {
        PrettyFormaterConfig c = this.config.pop();
        if (this.config.isEmpty()) {
            this.config.push(new PrettyFormaterConfig());
        }
    }

    @Override
    public void append(Object o) {
        PrettyFormaterConfig c = this.config.peek();
        c.builder().append(o);
    }

    @Override
    public String build() {
        PrettyFormaterConfig c = this.config.peek();
        if (c.builder == null) {
            return "";
        }
        return c.builder.toString();
    }

    private class PrettyFormaterConfig {
        int indentSize;
        int indentation;
        boolean useNl;
        StringBuilder builder;

        public PrettyFormaterConfig() {
            this.indentSize = 4;
            this.indentation = 0;
            this.useNl = false;
            this.builder = null;
        }

        public PrettyFormaterConfig(int indentation, boolean useNl) {
            this.indentation = indentation;
            this.useNl = useNl;
            this.builder = null;
        }

        public StringBuilder builder() {
            if (this.builder == null) {
                this.builder = new StringBuilder();
            }
            return this.builder;
        }
    }
}

