/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tasseledcap.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.BasicAPISwingPanel;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tasseledcap.app.MainWindow;
import org.gvsig.raster.tasseledcap.app.ProcessEndActions;
import org.gvsig.raster.tasseledcap.app.TasseledCapTocMenuEntry;
import org.gvsig.raster.tasseledcap.app.toolbox.ToolboxTasseledCapLoader;
import org.gvsig.raster.tasseledcap.swing.TasseledCapSwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class TasseledCapExtension
extends Extension
implements ActionListener {
    private BasicAPISwingPanel mainPanel = null;
    private MainWindow windowMainPanel = null;
    private FLyrRaster lyr = null;

    public void initialize() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("GenericToolBarMenu");
        point.append("TasseledCap", "", (ExtensionBuilder)TasseledCapTocMenuEntry.getSingleton());
        TasseledCapTocMenuEntry.setExtension(this);
        Messages.addResourceFamily((String)"org.gvsig.raster.tasseledcap.app.i18n.text", (ClassLoader)TasseledCapExtension.class.getClassLoader(), (String)TasseledCapExtension.class.getClass().getName());
        this.initilizeIcons();
    }

    public void postInitialize() {
        new ToolboxTasseledCapLoader().registerTool();
    }

    public void execute(String actionCommand) {
        if (actionCommand.compareTo("TasseledCap") == 0) {
            this.lyr = this.getSelectedLayer();
            if (this.lyr == null) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"layer_not_found"), null);
                return;
            }
            String defaultROIEPSG = this.getFirstMapCtrl().getProjection().getAbrev();
            this.mainPanel = TasseledCapSwingLocator.getSwingManager().createTasseledCapMainPanel((Object)this.lyr.getDataStore(), this.lyr.getName(), this.lyr.getDataStore().getBandCount(), defaultROIEPSG);
            this.windowMainPanel = new MainWindow(this.mainPanel.getComponent(), Messages.getText((String)"tasseled_cap"), 400, 420, this);
            PluginServices.getMDIManager().addCentredWindow((IWindow)this.windowMainPanel);
            this.mainPanel.initialize();
        }
    }

    private MapControl getFirstMapCtrl() {
        IWindow[] windowList = PluginServices.getMDIManager().getOrderedWindows();
        for (int i = 0; i < windowList.length; ++i) {
            if (!(windowList[i] instanceof IView)) continue;
            return ((IView)windowList[i]).getMapControl();
        }
        return null;
    }

    private FLyrRaster getSelectedLayer() {
        FLayer[] lyrList;
        MapControl firstMapCtrl = this.getFirstMapCtrl();
        if (firstMapCtrl != null && (lyrList = this.getFirstMapCtrl().getMapContext().getLayers().getActives()).length <= 1) {
            for (int i = 0; i < lyrList.length; ++i) {
                if (!(lyrList[i] instanceof FLyrRaster)) continue;
                return (FLyrRaster)lyrList[i];
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FLyrRaster selectedLayer = this.getSelectedLayer();
        if (selectedLayer == null) {
            return false;
        }
        if (!(selectedLayer instanceof ILayerState)) {
            return false;
        }
        if (!((ILayerState)selectedLayer).isOpen()) {
            return false;
        }
        if (selectedLayer.getRender().getFilterList().get("colortable") != null) {
            return false;
        }
        return selectedLayer.getDataStore().getBandCount() >= 4;
    }

    public boolean isVisible() {
        FLyrRaster selectedLayer = this.getSelectedLayer();
        if (selectedLayer == null) {
            return false;
        }
        if (!(selectedLayer instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedLayer).isActionEnabled(13);
    }

    void initilizeIcons() {
        IconThemeHelper.registerIcon(null, (String)"tasseled-cab", (Object)this);
        IconThemeHelper.registerIcon(null, (String)"gvsig-icon", (Object)this);
        IconThemeHelper.registerIcon(null, (String)"gvsig-icon16x16", (Object)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.windowMainPanel.getButtonsPanel().getButton(3) || e.getSource() == this.windowMainPanel.getButtonsPanel().getButton(1)) {
            DataProcess task = null;
            try {
                task = (DataProcess)this.mainPanel.getResult();
            }
            catch (Exception e1) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"problems_creating_process"), null);
                return;
            }
            task.setActions((IProcessActions)new ProcessEndActions(this.windowMainPanel, (FLayer)this.lyr));
            task.init();
            task.start();
        }
    }

    public void interrupted() {
    }

    public void updateProgress(int current, int total) {
    }
}

