/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.csw.parsers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.gvsig.catalog.csw.drivers.CSWCapabilities;
import org.gvsig.catalog.csw.drivers.CSWCatalogServiceDriver;
import org.gvsig.catalog.csw.parsers.CSWExceptionParser;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.utils.Strings;

public class CSWCapabilitiesParser {
    private URL url = null;
    private CSWCatalogServiceDriver driver = null;
    private CSWCapabilities capabilities = null;

    public CSWCapabilitiesParser(URL url, CSWCatalogServiceDriver driver) {
        this.url = url;
        this.driver = driver;
    }

    public CSWCapabilities parse(XMLNode node) {
        this.capabilities = new CSWCapabilities(this.url);
        if (node.getName().endsWith("ServiceExceptionReport")) {
            this.capabilities.setException(CSWExceptionParser.parse(node));
            this.capabilities.setAvailable(false);
            this.capabilities.setServerMessage(node.getXmlTree());
        }
        this.parseHeaderAttributes(node);
        this.parseServiceIdentification(node.searchNode("ServiceIdentification"));
        this.parseServiceProvider(node.searchNode("ServiceProvider"));
        this.parseOperationsMetadata(node.searchNode("OperationsMetadata"));
        return this.capabilities;
    }

    private void parseHeaderAttributes(XMLNode node) {
        this.capabilities.setVersion(node.searchAtribute("version"));
    }

    private void parseServiceIdentification(XMLNode node) {
        if (node != null) {
            XMLNode title = node.searchNode("Title");
            XMLNode abstract_ = node.searchNode("Abstract");
            String sTitle = "";
            if (title != null) {
                sTitle = title.getText() + "\n";
            }
            if (abstract_ != null) {
                sTitle = sTitle + abstract_.getText();
            }
            this.driver.setServerAnswerReady(sTitle);
            this.capabilities.setServerMessage(sTitle);
            XMLNode version = node.searchNode("ServiceTypeVersion");
            if (version != null) {
                this.capabilities.setVersion(version.getText());
            }
        }
    }

    private void parseServiceProvider(XMLNode node) {
        if (node != null) {
            // empty if block
        }
    }

    private void parseOperationsMetadata(XMLNode node) {
        if (node != null) {
            XMLNode[] operations = XMLTree.searchMultipleNode(node, "Operation");
            for (int i = 0; i < operations.length; ++i) {
                String sOperation = XMLTree.searchAtribute(operations[i], "name");
                if (sOperation.equals("GetCapabilities")) {
                    this.parseCapabilities(operations[i]);
                }
                if (sOperation.equals("DescribeRecord")) {
                    this.parseDescribeRecord(operations[i]);
                }
                if (sOperation.equals("GetDomain")) {
                    this.parseGetDomain(operations[i]);
                }
                if (sOperation.equals("GetRecords")) {
                    this.parseGetRecords(operations[i]);
                }
                if (sOperation.equals("GetRecordsById")) {
                    this.parseGetRecordsByID(operations[i]);
                }
                if (sOperation.equals("Transaction")) {
                    this.parseTransaction(operations[i]);
                }
                if (!sOperation.equals("Harvest")) continue;
                this.parseHarvest(operations[i]);
            }
            if (this.capabilities.getVersion().equals("0.9.0")) {
                this.capabilities.getOperations().getGetExtrinsicContent().put("Get", this.url);
            }
        }
    }

    private void parseCapabilities(XMLNode node) {
        this.capabilities.getOperations().setGetCapabilities(this.getSupportedProtocols(node));
        XMLNode[] parameters = XMLTree.searchMultipleNode(node, "Parameter");
        for (int i = 0; i < parameters.length; ++i) {
            String sParameter = XMLTree.searchAtribute(parameters[i], "name");
            String[] values = XMLTree.searchMultipleNodeValue(parameters[i], "Value");
            if (!sParameter.toLowerCase().equals("version") || values == null || values.length != 1) continue;
            this.capabilities.setVersion(values[0]);
        }
    }

    private void parseDescribeRecord(XMLNode node) {
        this.capabilities.getOperations().setDescribeRecords(this.getSupportedProtocols(node));
        XMLNode[] parameters = XMLTree.searchMultipleNode(node, "Parameter");
        for (int i = 0; i < parameters.length; ++i) {
            String sParameter = XMLTree.searchAtribute(parameters[i], "name");
            String[] values = XMLTree.searchMultipleNodeValue(parameters[i], "Value");
            if (!sParameter.equals("typeName") || values == null) continue;
            this.capabilities.setTypeNames(values);
        }
    }

    private void parseGetRecordsByID(XMLNode node) {
        this.capabilities.getOperations().setGetRecordsById(this.getSupportedProtocols(node));
    }

    private void parseGetDomain(XMLNode node) {
        this.capabilities.getOperations().setGetDomain(this.getSupportedProtocols(node));
    }

    private void parseGetRecords(XMLNode node) {
        this.capabilities.getOperations().setGetRecords(this.getSupportedProtocols(node));
        XMLNode[] parameters = XMLTree.searchMultipleNode(node, "Parameter");
        for (int i = 0; i < parameters.length; ++i) {
            String sParameter = XMLTree.searchAtribute(parameters[i], "name");
            String[] values = XMLTree.searchMultipleNodeValue(parameters[i], "Value");
            String[] defaultValue = XMLTree.searchMultipleNodeValue(parameters[i], "DefaultValue");
            if (sParameter.equals("TypeName")) {
                this.capabilities.setTypeNames(Strings.join(defaultValue, values));
            }
            if (!(!sParameter.equals("outputFormat") || Strings.find("text/xml", defaultValue) || Strings.find("text/xml", values) || Strings.find("application/xml", defaultValue) || Strings.find("application/xml", values))) {
                this.capabilities.setServerMessage("El servidor no devuelve texto en formato XML");
                return;
            }
            this.driver.setOutputFormat("text/xml");
            if (sParameter.equals("outputSchema")) {
                this.driver.setOutputSchema(Strings.join(defaultValue, values));
            }
            if (sParameter.equals("resultType")) {
                this.capabilities.setResultType(Strings.join(defaultValue, values));
            }
            if (sParameter.equals("ElementSetName")) {
                this.capabilities.setElementSetName(Strings.join(defaultValue, values));
            }
            if (!sParameter.equals("CONSTRAINTLANGUAGE")) continue;
            this.capabilities.setCONSTRAINTLANGUAGE(Strings.join(defaultValue, values));
            for (int j = 0; j < this.capabilities.getCONSTRAINTLANGUAGE().length && !this.capabilities.getCONSTRAINTLANGUAGE()[j].toUpperCase().equals("FILTER"); ++j) {
                this.capabilities.setServerMessage("errorFENotSupported");
            }
        }
    }

    private void parseTransaction(XMLNode node) {
        this.capabilities.getOperations().setTransaction(this.getSupportedProtocols(node));
    }

    private void parseHarvest(XMLNode node) {
        this.capabilities.getOperations().setHarvest(this.getSupportedProtocols(node));
    }

    private HashMap getSupportedProtocols(XMLNode node) {
        HashMap<String, URL> operations = new HashMap<String, URL>();
        XMLNode protocols = XMLTree.searchNode(node, "DCP");
        XMLNode HTTPoperations = XMLTree.searchNode(protocols, "HTTP");
        XMLNode[] childNodes = HTTPoperations.getSubnodes();
        for (int i = 0; i < childNodes.length; ++i) {
            String sUrl = XMLTree.searchAtribute(childNodes[i], "xlink:href");
            URL url = null;
            try {
                url = new URL(sUrl);
                if (childNodes[i].getName().endsWith("Get")) {
                    operations.put("Get", url);
                }
                if (!childNodes[i].getName().endsWith("Post")) continue;
                operations.put("Post", url);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return operations;
    }
}

