/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.protocols;

import java.net.URI;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gvsig.catalog.drivers.GetRecordsReply;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.protocols.Z3950ConnectionFactory;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.search.provider.iface.IRQuery;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.provider.iface.Searchable;
import org.jzkit.search.util.QueryModel.PrefixString.PrefixString;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.RecordModel.SUTRS;
import org.jzkit.search.util.RecordModel.XMLRecord;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.z3950.client.SynchronousOriginBean;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeResponse_type;

public class Z3950Connection
extends SynchronousOriginBean {
    public static final char ISO2709_RS = '\u001d';
    public static final char ISO2709_FS = '\u001e';
    public static final char ISO2709_IDFS = '\u001f';
    private static final String PREFIX_QUERY_TYPE = "PREFIX";
    private static final String CCL_QUERY_TYPE = "CCL";
    private int auth_type = 0;
    private String principal = null;
    private String group = null;
    private String credentials = null;
    private InitializeResponse_type resp = null;
    private URI uri = null;
    private String host = null;
    private int port = 0;
    private String database = null;

    public Z3950Connection(URI uri) {
        super(new OIDRegister("/a2j.properties"));
        this.uri = uri;
        this.host = uri.getHost();
        this.port = uri.getPort();
        StringTokenizer sti = new StringTokenizer(uri.getPath(), "/");
        this.database = sti.countTokens() == 0 ? "geo" : sti.nextToken();
    }

    public String connect() {
        if (this.resp == null) {
            this.resp = this.connect(this.host, this.port, this.auth_type, this.principal, this.group, this.credentials);
        }
        StringBuffer string = new StringBuffer();
        if (this.resp == null) {
            return null;
        }
        if (this.resp.result.booleanValue()) {
            if (this.resp.referenceId != null) {
                string.append("Reference ID : " + new String(this.resp.referenceId) + "\n");
            }
        } else {
            System.out.println(" Failed to establish association");
            return null;
        }
        string.append("Implementation ID : " + this.resp.implementationId + "\n");
        string.append("Implementation Name : " + this.resp.implementationName + "\n");
        string.append("Implementation Version : " + this.resp.implementationVersion + "\n");
        return string.toString();
    }

    public GetRecordsReply search(GetRecordsReply recordsReply, String sQuery, int firstRecord) {
        try {
            IRQuery query = new IRQuery();
            query.collections = new Vector();
            query.collections.add(this.database);
            query.query = new PrefixString(sQuery);
            Searchable s = Z3950ConnectionFactory.getSearchable(this.uri);
            IRResultSet result = s.evaluate(query);
            result.waitForStatus(12, 0L);
            int numOfResults = result.getFragmentCount();
            recordsReply.setNumRecords(numOfResults);
            ExplicitRecordFormatSpecification rfs = new ExplicitRecordFormatSpecification(null, null, "f");
            InformationFragment[] fragment = result.getFragment(firstRecord, 10, (RecordFormatSpecification)rfs);
            for (int i = 0; i < fragment.length; ++i) {
                try {
                    String answer = "";
                    if (fragment[i] instanceof XMLRecord) {
                        XMLRecord xml = (XMLRecord)fragment[i];
                        answer = xml.toString();
                    } else {
                        SUTRS sutr = (SUTRS)fragment[i];
                        answer = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><NOTXML>" + sutr.toString() + "</" + "NOTXML" + ">";
                    }
                    recordsReply.addRecord(this.uri, XMLTree.xmlToTree(answer));
                    continue;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (SearchException e) {
            e.printStackTrace();
        }
        catch (IRResultSetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return recordsReply;
    }
}

