/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.schemas;

import java.net.URI;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.querys.Coordinates;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;

public class Iso19139Record
extends Record {
    public Iso19139Record() {
    }

    public Iso19139Record(URI uri, XMLNode node) {
        super(uri, node);
        this.setTitle(node.searchNodeValue("identificationInfo->MD_DataIdentification->citation->CI_Citation->title->CharacterString"));
        this.setAbstract_(node.searchNodeValue("identificationInfo->MD_DataIdentification->abstract->gco:CharacterString"));
        this.setPurpose(node.searchNodeValue("dataIdInfo->idPurp"));
        this.setKeyWords(node.searchMultipleNodeValue("identificationInfo->MD_DataIdentification->descriptiveKeywords->MD_Keywords->keyword->gco:CharacterString"));
        this.setResources(this.getResources("distributionInfo->MD_Distribution->transferOptions->MD_DigitalTransferOptions->onLine->CI_OnlineResource"));
        this.setFileID(node.searchNodeValue("mdFileID"));
        this.setImageURL(node.searchNodeValue("dataIdInfo->graphOver"));
    }

    private Resource[] getResources(String label) {
        XMLNode[] nodes = XMLTree.searchMultipleNode(this.getNode(), label);
        Coordinates coordinates = null;
        String srs = null;
        if (nodes == null) {
            return null;
        }
        Resource[] resources = new Resource[nodes.length];
        if (nodes.length > 0) {
            srs = XMLTree.searchNodeValue(this.getNode(), "refSysInfo->MdCoRefSys->refSysID->identCode");
            coordinates = new Coordinates(XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->westBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->northBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->eastBL"), XMLTree.searchNodeValue(this.getNode(), "dataIdInfo->geoBox->southBL"));
        }
        for (int i = 0; i < resources.length; ++i) {
            resources[i] = new Resource(XMLTree.searchNodeValue(nodes[i], "linkage->URL"), XMLTree.searchNodeValue(nodes[i], "protocol->gco:CharacterString"), XMLTree.searchNodeValue(nodes[i], "name->gco:CharacterString"), XMLTree.searchNodeValue(nodes[i], "orDesc"), XMLTree.searchNodeAtribute(nodes[i], "orFunct->OnFunctCd", "value"), srs, coordinates);
            if (resources[i].getLinkage() != null) continue;
            resources[i].setLinkage("");
        }
        return resources;
    }

    @Override
    public boolean accept(URI uri, XMLNode node) {
        return node.getName().endsWith("MD_Metadata") && node.searchNode("identificationInfo->MD_DataIdentification->citation->CI_Citation->title") != null;
    }
}

