/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.chooseresource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.catalog.ui.chooseresource.ChooseResourcePanel;
import org.gvsig.catalog.utils.resourcestable.ButtonEditor;
import org.gvsig.catalog.utils.resourcestable.ButtonRenderer;
import org.gvsig.i18n.Messages;

public class ChooseResourceDialogPanel
extends JPanel
implements ActionListener {
    private JFrame parent;
    private ChooseResourcePanel controlsPanel = null;
    private JPanel buttonsPanel = null;
    private JButton cerrar = null;
    private Collection resources = new ArrayList();

    public ChooseResourceDialogPanel(Collection resources) {
        this.resources = resources;
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this.getControlsPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.setDefaultButtonListeners();
    }

    public ChooseResourcePanel getControlsPanel() {
        if (this.controlsPanel == null) {
            this.controlsPanel = new ChooseResourcePanel(this.resources);
            this.controlsPanel.setLocation(0, 0);
        }
        return this.controlsPanel;
    }

    public JPanel getButtonPanel() {
        if (this.buttonsPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonsPanel = new JPanel(flowLayout);
            this.buttonsPanel.add(this.getCloseButton());
        }
        return this.buttonsPanel;
    }

    public JButton getCloseButton() {
        if (this.cerrar == null) {
            this.cerrar = new JButton(Messages.getText((String)"close"));
            this.cerrar.setPreferredSize(new Dimension(80, 23));
            this.cerrar.setActionCommand("close");
        }
        return this.cerrar;
    }

    public void setDefaultButtonListeners() {
        this.getCloseButton().addActionListener(this);
        this.getControlsPanel().getTable().getColumn(Messages.getText((String)"resourceShowColumn")).setCellRenderer(new ButtonRenderer());
        this.getControlsPanel().getTable().getColumn(Messages.getText((String)"resourceShowColumn")).setCellEditor(new ButtonEditor(new JCheckBox(), this.resources, this));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("close".equals(e.getActionCommand())) {
            this.closeButtonActionPerformed();
        }
        System.out.println(e.getActionCommand());
    }

    public void resourceButtonActionPerformed(Resource resource) {
        System.out.println(resource.getLinkage() + " no se puede cargar sin usar gvSIG");
    }

    public void closeButtonActionPerformed() {
        this.parent.setVisible(false);
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }
}

