/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.serverproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.catalog.drivers.profiles.IProfile;
import org.gvsig.catalog.utils.CatalogConstants;
import org.gvsig.i18n.Messages;
import org.gvsig.utils.swing.jcomboServer.ServerData;

public class ServerPropertiesPanel
extends JPanel {
    private ServerData serverData = null;
    private IProfile profile = null;
    private JLabel abstractLabel;
    private JTextField abstractText;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JLabel cathegoryLabel;
    private JTextField cathegoryText;
    private JButton closeButton;
    private JPanel componetsPanel;
    private JLabel coordinatesLabel;
    private JTextField coordinatesText;
    private JLabel dateFromLabel;
    private JTextField dateFromText;
    private JLabel dateToLabel;
    private JTextField dateToText;
    private JLabel elementLabelText;
    private JTextField elementNameText;
    private JLabel keywordLabel;
    private JTextField keywordsText;
    private JPanel labelsPanel;
    private JLabel providerLabel;
    private JTextField providerText;
    private JLabel scaleLabel;
    private JTextField scaleText;
    private JPanel textsPanel;
    private JLabel titleLabel;
    private JTextField titleText;

    public ServerPropertiesPanel(ServerData serverData, IProfile profile) {
        this.serverData = serverData;
        this.profile = profile;
        this.initializeComponents();
        this.initializeLabels();
        this.initServerFields();
        this.initButtonSize();
        this.completeFieldsWithProfile();
    }

    private void initializeComponents() {
        this.componetsPanel = new JPanel();
        this.labelsPanel = new JPanel();
        this.titleText = new JTextField();
        this.titleLabel = new JLabel();
        this.abstractLabel = new JLabel();
        this.keywordLabel = new JLabel();
        this.cathegoryLabel = new JLabel();
        this.scaleLabel = new JLabel();
        this.providerLabel = new JLabel();
        this.coordinatesLabel = new JLabel();
        this.dateFromLabel = new JLabel();
        this.dateToLabel = new JLabel();
        this.elementLabelText = new JLabel();
        this.abstractText = new JTextField();
        this.keywordsText = new JTextField();
        this.cathegoryText = new JTextField();
        this.scaleText = new JTextField();
        this.providerText = new JTextField();
        this.coordinatesText = new JTextField();
        this.dateFromText = new JTextField();
        this.dateToText = new JTextField();
        this.elementNameText = new JTextField();
        this.buttonsPanel = new JPanel();
        this.cancelButton = new JButton();
        this.closeButton = new JButton();
        this.setLayout(new BorderLayout());
        this.componetsPanel.setLayout(new GridBagLayout());
        this.componetsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.titleText, gridBagConstraints);
        this.titleLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.titleLabel, gridBagConstraints);
        this.abstractLabel.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.abstractLabel, gridBagConstraints);
        this.keywordLabel.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.keywordLabel, gridBagConstraints);
        this.cathegoryLabel.setText("jLabel4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.cathegoryLabel, gridBagConstraints);
        this.scaleLabel.setText("jLabel5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.scaleLabel, gridBagConstraints);
        this.providerLabel.setText("jLabel6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 1);
        this.labelsPanel.add((Component)this.providerLabel, gridBagConstraints);
        this.coordinatesLabel.setText("jLabel7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.coordinatesLabel, gridBagConstraints);
        this.dateFromLabel.setText("jLabel8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.dateFromLabel, gridBagConstraints);
        this.dateToLabel.setText("jLabel9");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.dateToLabel, gridBagConstraints);
        this.elementLabelText.setText("jLabel10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.labelsPanel.add((Component)this.elementLabelText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.abstractText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.keywordsText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.cathegoryText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.scaleText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.providerText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.coordinatesText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.dateFromText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.dateToText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.labelsPanel.add((Component)this.elementNameText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.componetsPanel.add((Component)this.labelsPanel, gridBagConstraints);
        this.add((Component)this.componetsPanel, "North");
        this.buttonsPanel.setLayout(new FlowLayout(2));
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.cancelButton.setText("cancel");
        this.buttonsPanel.add(this.cancelButton);
        this.closeButton.setText("close");
        this.buttonsPanel.add(this.closeButton);
        this.add((Component)this.buttonsPanel, "South");
    }

    private void initializeLabels() {
        this.titleLabel.setText(Messages.getText((String)"title") + ":");
        this.abstractLabel.setText(Messages.getText((String)"abstract") + ":");
        this.keywordLabel.setText(Messages.getText((String)"keyWords") + ":");
        this.cathegoryLabel.setText(Messages.getText((String)"cathegory") + ":");
        this.scaleLabel.setText(Messages.getText((String)"scale") + ":");
        this.providerLabel.setText(Messages.getText((String)"provider") + ":");
        this.coordinatesLabel.setText(Messages.getText((String)"coordinates") + ":");
        this.dateFromLabel.setText(Messages.getText((String)"from"));
        this.dateToLabel.setText(Messages.getText((String)"to"));
        this.elementLabelText.setText(Messages.getText((String)"elementName") + ":");
        this.closeButton.setText(Messages.getText((String)"aceptar"));
        this.cancelButton.setText(Messages.getText((String)"cancel"));
    }

    private void initServerFields() {
        this.titleText.setText(this.serverData.getProperty("titlePropertyName"));
        this.abstractText.setText(this.serverData.getProperty("abstractPropertyName"));
        this.keywordsText.setText(this.serverData.getProperty("keywordsPropertyName"));
        this.cathegoryText.setText(this.serverData.getProperty("cathegoryPropertyName"));
        this.scaleText.setText(this.serverData.getProperty("scalePropertyName"));
        this.providerText.setText(this.serverData.getProperty("providerPropertyName"));
        this.coordinatesText.setText(this.serverData.getProperty("coordinatesPropertyName"));
        this.dateFromText.setText(this.serverData.getProperty("datefromPropertyName"));
        this.dateToText.setText(this.serverData.getProperty("datetoPropertyName"));
        this.elementNameText.setText(this.serverData.getProperty("elementNamePropertyName"));
    }

    private void completeFieldsWithProfile() {
        if (this.profile != null) {
            if (this.titleText.getText() == null || this.titleText.getText().compareTo("") == 0) {
                this.titleText.setText(this.profile.getTitleProperty());
            }
            if (this.abstractText.getText() == null || this.abstractText.getText().compareTo("") == 0) {
                this.abstractText.setText(this.profile.getAbstractProperty());
            }
            if (this.keywordsText.getText() == null || this.keywordsText.getText().compareTo("") == 0) {
                this.keywordsText.setText(this.profile.getKeywordsProperty());
            }
            if (this.cathegoryText.getText() == null || this.cathegoryText.getText().compareTo("") == 0) {
                this.cathegoryText.setText(this.profile.getTopicProperty());
            }
            if (this.scaleText.getText() == null || this.scaleText.getText().compareTo("") == 0) {
                this.scaleText.setText(this.profile.getScaleProperty());
            }
            if (this.providerText.getText() == null || this.providerText.getText().compareTo("") == 0) {
                this.providerText.setText(this.profile.getProviderProperty());
            }
            if (this.coordinatesText.getText() == null || this.coordinatesText.getText().compareTo("") == 0) {
                this.coordinatesText.setText(this.profile.getCoordinatesProperty());
            }
            if (this.dateFromText.getText() == null || this.dateFromText.getText().compareTo("") == 0) {
                this.dateFromText.setText(this.profile.getDateFromProperty());
            }
            if (this.dateToText.getText() == null || this.dateToText.getText().compareTo("") == 0) {
                this.dateToText.setText(this.profile.getDateToProperty());
            }
            if (this.elementNameText.getText() == null || this.elementNameText.getText().compareTo("") == 0) {
                this.elementNameText.setText(this.profile.getElementNameProperty());
            }
        }
    }

    private void initButtonSize() {
        this.cancelButton.setPreferredSize(CatalogConstants.BUTTON_SIZE);
        this.closeButton.setPreferredSize(CatalogConstants.BUTTON_SIZE);
    }

    protected ServerData updateServerData() {
        Properties properties = this.serverData.getProperies();
        if (properties == null) {
            properties = new Properties();
        }
        this.updateProperty(this.titleText.getText(), this.profile.getTitleProperty(), "titlePropertyName", properties);
        this.updateProperty(this.abstractText.getText(), this.profile.getAbstractProperty(), "abstractPropertyName", properties);
        this.updateProperty(this.keywordsText.getText(), this.profile.getKeywordsProperty(), "keywordsPropertyName", properties);
        this.updateProperty(this.cathegoryText.getText(), this.profile.getTopicProperty(), "cathegoryPropertyName", properties);
        this.updateProperty(this.providerText.getText(), this.profile.getProviderProperty(), "providerPropertyName", properties);
        this.updateProperty(this.scaleText.getText(), this.profile.getScaleProperty(), "scalePropertyName", properties);
        this.updateProperty(this.coordinatesText.getText(), this.profile.getCoordinatesProperty(), "coordinatesPropertyName", properties);
        this.updateProperty(this.dateFromText.getText(), this.profile.getDateFromProperty(), "datefromPropertyName", properties);
        this.updateProperty(this.dateToText.getText(), this.profile.getDateToProperty(), "datetoPropertyName", properties);
        this.updateProperty(this.elementNameText.getText(), this.profile.getElementNameProperty(), "elementNamePropertyName", properties);
        this.serverData.setProperies(properties);
        return this.serverData;
    }

    private void updateProperty(String text, String profileValue, String key, Properties properties) {
        if (text != null && !text.equals("")) {
            if (profileValue == null) {
                properties.setProperty(key, text);
            } else if (text.compareTo(profileValue) != 0) {
                properties.setProperty(key, text);
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        this.closeButton.setActionCommand("close");
        this.closeButton.addActionListener(listener);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(listener);
    }
}

