/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.utils;

import java.util.TreeMap;
import java.util.Vector;

public class Strings {
    public static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static boolean find(String pattern, String[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!pattern.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] join(String[] s1, String[] s2) {
        int i;
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        String[] out = new String[s1.length + s2.length];
        for (i = 0; i < s1.length; ++i) {
            out[i] = s1[i];
        }
        for (i = 0; i < s2.length; ++i) {
            out[s1.length + i] = s2[i];
        }
        return out;
    }

    public static String getComaSeparated(String[] input) {
        return Strings.getXSeparated(",", input);
    }

    public static String getBlankSeparated(String[] input) {
        return Strings.getXSeparated(" ", input);
    }

    private static String getXSeparated(String X, String[] input) {
        String output = "";
        if (input.length == 0) {
            return "";
        }
        output = input[0];
        for (int i = 1; i < input.length; ++i) {
            output = output + X + input[i];
        }
        return output;
    }

    public static String addAsteriscsFromAnArray(String array) {
        String[] s = array.split(" ");
        String output = "";
        for (int i = 0; i < s.length; ++i) {
            output = output + " *" + s[i] + "*";
        }
        return output;
    }

    public static String tryIfIsNumber(String str, int charNumber) {
        char[] source = str.toCharArray();
        if (source.length < charNumber) {
            charNumber = source.length;
        }
        char[] resultado = new char[charNumber];
        int j = 0;
        for (int i = 0; i < resultado.length; ++i) {
            if (i >= source.length || source[i] < '0' || source[i] > '9') continue;
            resultado[j++] = source[i];
        }
        return new String(resultado, 0, j);
    }

    public static String removeAccents(String str) {
        str = str.replace('\u00e1', 'a');
        str = str.replace('\u00e9', 'e');
        str = str.replace('\u00ed', 'i');
        str = str.replace('\u00f3', 'o');
        str = str.replace('\u00fa', 'u');
        str = str.replace('\u00c1', 'A');
        str = str.replace('\u00c9', 'E');
        str = str.replace('\u00cd', 'I');
        str = str.replace('\u00d3', 'O');
        str = str.replace('\u00e0', 'a');
        str = str.replace('\u00e8', 'e');
        str = str.replace('\u00ec', 'i');
        str = str.replace('\u00f2', 'o');
        str = str.replace('\u00f9', 'u');
        str = str.replace('\u00c0', 'A');
        str = str.replace('\u00c8', 'E');
        str = str.replace('\u00cc', 'I');
        str = str.replace('\u00d2', 'O');
        str = str.replace('\u00d9', 'U');
        str = str.replace('\u00e4', 'a');
        str = str.replace('\u00eb', 'e');
        str = str.replace('\u00ef', 'i');
        str = str.replace('\u00f6', 'o');
        str = str.replace('\u00fc', 'u');
        str = str.replace('\u00c4', 'A');
        str = str.replace('\u00cb', 'E');
        str = str.replace('\u00cf', 'I');
        str = str.replace('\u00d6', 'O');
        str = str.replace('\u00dc', 'U');
        return str;
    }

    public static Vector allWordForms(String str, boolean withAccents) {
        Vector<String> v = new Vector<String>();
        if (!withAccents) {
            str = Strings.removeAccents(str);
        }
        v.add(str);
        v.add(str.toLowerCase());
        v.add(str.toUpperCase());
        v.add(Strings.getUperCaseFirst(str));
        if (withAccents) {
            str = Strings.removeAccents(str);
            v.add(str.toLowerCase());
            v.add(str.toUpperCase());
            v.add(Strings.getUperCaseFirst(str));
        }
        return v;
    }

    public static String getUperCaseFirst(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length()).toLowerCase();
    }

    public static TreeMap separateParams(String pairValues) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] params = pairValues.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] nameValue = params[i].split("=");
            map.put(nameValue[0].toUpperCase(), nameValue[1]);
        }
        return map;
    }
}

