/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.tile.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.gvsig.raster.cache.tile.TileCache;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.cache.tile.disk.ITileFileSystemStrategy;
import org.gvsig.raster.cache.tile.impl.DefaultTileCacheManager;
import org.gvsig.raster.cache.tile.impl.layer.TiledLayerImpl;
import org.gvsig.raster.cache.tile.layer.TiledLayer;
import org.gvsig.raster.cache.tile.provider.TileServer;

public class TileCacheImpl
implements TileCache {
    private ArrayList<TiledLayerImpl> layerList = new ArrayList();
    private String baseDir = null;
    private double currentSize = 0.0;
    protected String preffixSizeFileName = "c_len";
    protected String configDir = ".metadata";

    public TileCacheImpl(String baseDir) {
        this.baseDir = baseDir;
        this.loadSize();
    }

    public void updateBaseDirectory(String dir) {
        this.baseDir = dir;
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).updateBaseDirectory(dir);
        }
    }

    public synchronized void updateSize(long sizeBytes) {
        this.currentSize += (double)sizeBytes;
    }

    private void loadSize() {
        File f = new File(this.baseDir + File.separator + this.configDir);
        if (!f.exists()) {
            f.mkdirs();
            this.saveSize();
        }
        String[] list = f.list();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].startsWith(this.preffixSizeFileName)) continue;
            String s = list[i].substring(5, list[i].length());
            try {
                this.currentSize = Double.valueOf(s);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public synchronized void saveSize() {
        String[] list;
        String dir = this.baseDir + File.separator + this.configDir;
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        if ((list = f.list()) != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].startsWith(this.preffixSizeFileName)) continue;
                new File(dir + File.separator + list[i]).delete();
            }
        }
        try {
            new File(dir + File.separator + this.preffixSizeFileName + (int)this.currentSize).createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isFullDiskCache() {
        return this.currentSize >= (double)(TileCacheLibrary.MAX_CACHE_SIZE * 0x100000);
    }

    public TiledLayer createLayer(TileServer provider, String strategyType) {
        ITileFileSystemStrategy strat = ((DefaultTileCacheManager)TileCacheLocator.getManager()).createStrategy(strategyType);
        TiledLayerImpl l = new TiledLayerImpl(this, provider, strat);
        this.layerList.add(l);
        return l;
    }

    public String getBaseDirectory() {
        return this.baseDir;
    }

    public String getConfigurationDirectory() {
        return this.configDir;
    }

    public void removeLayer(TiledLayer layer) {
        this.layerList.remove(layer);
        this.updateSize(-layer.delete());
        this.saveSize();
    }
}

