/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.downloader;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.cache.tile.provider.Downloader;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.osm.cachestruct.OSMCacheStruct;
import org.gvsig.raster.osm.downloader.TileDownloaderForOSM;
import org.gvsig.raster.osm.io.OSMDataParameters;

public class OSMTileServer
implements TileServer {
    private CacheStruct struct = null;
    private Downloader downloader = null;
    private RasterDataStore store = null;
    private String suffix = null;
    private int tileSize = 256;
    private int levels = 0;

    public OSMTileServer(RasterDataStore store, String suffix, int levels) {
        this.store = store;
        this.suffix = suffix;
        this.levels = levels;
    }

    public Downloader getDownloader() {
        if (this.downloader == null) {
            this.downloader = new TileDownloaderForOSM(this.store, this.getStruct().getTileSizeByLevel(0)[0]);
        }
        return this.downloader;
    }

    public CacheStruct getStruct() {
        if (this.struct == null) {
            this.struct = new OSMCacheStruct(this.levels, this.tileSize, this.tileSize, ((OSMDataParameters)this.store.getParameters()).getOSMLayerName(), RasterLibrary.pathTileCache, this.suffix, 0L);
        }
        return this.struct;
    }

    public void setStruct(CacheStruct struct) {
    }

    public String getFileSuffix() {
        return this.suffix;
    }

    public void setFileSuffix(String extension) {
        this.suffix = extension;
    }
}

