/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ExceptionLogger;
import org.apache.http.impl.nio.bootstrap.HttpServer;
import org.apache.http.impl.nio.bootstrap.ServerBootstrap;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportServices;
import org.gvsig.report.lib.api.commands.Command;
import org.gvsig.report.lib.api.commands.CommandFactory;
import org.gvsig.report.lib.impl.HttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReportServer
implements ReportServer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReportServer.class);
    private static final List<HttpServer> servers = new ArrayList<HttpServer>();
    private HttpServer server;
    private final Set<ReportServer.LoggerListener> loglisteners;
    private Map<String, Command> commands;
    private final ReportServerConfig config;
    private final ReportManager manager;

    public DefaultReportServer(ReportManager manager, ReportServerConfig config) {
        this.manager = manager;
        this.config = config;
        this.loglisteners = new HashSet<ReportServer.LoggerListener>();
    }

    public Map<String, Command> getCommands() {
        if (this.commands == null) {
            LinkedHashMap<String, Command> theCommands = new LinkedHashMap<String, Command>();
            for (CommandFactory factory : this.manager.getCommandFactories()) {
                theCommands.put(factory.getName(), factory.create((ReportServer)this));
            }
            this.commands = theCommands;
        }
        return this.commands;
    }

    public Command getCommand(String commandName) {
        if (commandName == null) {
            return null;
        }
        Command command = this.getCommands().get(commandName.toLowerCase());
        return command;
    }

    public ReportServerConfig getConfig() {
        return this.config;
    }

    public ReportServices getServices() {
        if (this.getConfig() == null) {
            return null;
        }
        return this.getConfig().getServices();
    }

    public void addLogListener(ReportServer.LoggerListener logger) {
        this.loglisteners.add(logger);
    }

    public void removeLogListener(ReportServer.LoggerListener logger) {
        this.loglisteners.remove(logger);
    }

    public URL getURL(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        try {
            URL url = new URL("http", "localhost", this.config.getPort(), path);
            return url;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public String getHost() {
        String host = "http://localhost:" + this.config.getPort();
        return host;
    }

    public void log(int level, String message) {
        switch (level) {
            default: {
                LOG.info(message);
                break;
            }
            case 1: {
                LOG.warn(message);
                break;
            }
            case 2: {
                LOG.debug(message);
            }
        }
        for (ReportServer.LoggerListener logger : this.loglisteners) {
            logger.log(level, message);
        }
    }

    public synchronized void start() {
        if (this.server != null) {
            this.stop();
        }
        IOReactorConfig theConfig = IOReactorConfig.custom().setSoTimeout(this.config.getTimeout()).setTcpNoDelay(true).build();
        this.server = ServerBootstrap.bootstrap().setListenerPort(this.config.getPort()).setServerInfo(this.config.getServerInfo()).setIOReactorConfig(theConfig).setExceptionLogger(ExceptionLogger.STD_ERR).registerHandler("*", (HttpAsyncRequestHandler)new HttpHandler(this)).create();
        try {
            this.server.start();
            servers.add(this.server);
            this.log(0, "Server started.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reload() {
    }

    public synchronized boolean isStarted() {
        return this.server != null;
    }

    public synchronized void stop() {
        if (this.server == null) {
            this.log(0, "Server already stoped.");
            return;
        }
        this.server.shutdown(5L, TimeUnit.SECONDS);
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        servers.remove(this.server);
        this.server = null;
        this.log(0, "Server stoped.");
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (HttpServer server : servers) {
                    server.shutdown(5L, TimeUnit.SECONDS);
                }
            }
        });
    }
}

