/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import ar.com.fdvs.dj.domain.CustomExpression;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JsonData;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.EditableForeingKey;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.report.lib.impl.ReportImplLibrary;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.GetItem64;
import org.gvsig.tools.util.Size;
import org.gvsig.tools.util.Size64;
import org.gvsig.tools.util.UnmodifiableBasicList64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRFeatureStoreDataSource
implements JRRewindableDataSource,
JsonData,
Size64,
Size,
GetItem<Feature>,
GetItem64<Feature> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JRFeatureStoreDataSource.class);
    private UnmodifiableBasicList64<Feature> features;
    private long index;
    private final StoresRepository storesRepository;
    private final JasperReportsContext context;
    protected String name;
    private Map<String, Coercion> coercions;
    private final FeatureType featureType;
    private final Map<String, DynObjectValueItem[]> availableValues;
    private FeatureSymbolTable featureSymbolTable;
    private static final DynObjectValueItem[] INVALID_AVAILABLE_VALUES = new DynObjectValueItem[1];

    public JRFeatureStoreDataSource(JasperReportsContext context, UnmodifiableBasicList64<Feature> features, StoresRepository storesRepository, FeatureType featureType) {
        this.context = context;
        this.features = features;
        this.storesRepository = storesRepository;
        this.index = -1L;
        this.name = "<unknown>";
        this.coercions = new HashMap<String, Coercion>();
        this.featureType = featureType;
        this.availableValues = new HashMap<String, DynObjectValueItem[]>();
        LOGGER.info("DataSource(" + this.name + ")");
        this.calculateAvailableValues();
    }

    public JRFeatureStoreDataSource(JasperReportsContext context, FeatureStore store, Expression filter) {
        this(context, (UnmodifiableBasicList64<Feature>)((UnmodifiableBasicList64)store.getFeatures(filter)), store.getStoresRepository(), store.getDefaultFeatureTypeQuietly());
        this.name = store.getName();
    }

    private void calculateAvailableValues() {
        for (FeatureAttributeDescriptor featureAttributeDescriptor : this.featureType) {
        }
    }

    public boolean next() throws JRException {
        ++this.index;
        boolean n = this.index < this.features.size64();
        return n;
    }

    public String getLabel(Feature feature, String fieldName) {
        Object value;
        block9: {
            DynObjectValueItem[] theAvailableValues = this.availableValues.get(fieldName);
            value = feature.get(fieldName);
            try {
                if (theAvailableValues == INVALID_AVAILABLE_VALUES) break block9;
                if (theAvailableValues == null) {
                    String labelPhrase;
                    DynObjectValueItem[] attr = this.featureType.getAttributeDescriptor(fieldName);
                    if (attr.hasAvailableValues()) {
                        this.availableValues.put(attr.getName(), attr.getAvailableValues(null));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(labelPhrase = attr.getTags().getString(ReportImplLibrary.TAG_REPORT_ATTR_LABEL, null))) && attr.isForeingKey()) {
                        try {
                            EditableForeingKey fk = (EditableForeingKey)attr.getForeingKey().clone();
                            fk.unbind();
                            fk.setLabelFormula(labelPhrase);
                            this.availableValues.put(attr.getName(), fk.getAvailableValues(null));
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            LOGGER.warn("Not able to clone foreing key. " + cloneNotSupportedException.toString());
                        }
                    }
                    theAvailableValues = this.availableValues.get(fieldName);
                }
                if (theAvailableValues != null) {
                    for (FeatureAttributeDescriptor featureAttributeDescriptor : theAvailableValues) {
                        if (!Objects.equals(value, featureAttributeDescriptor.getValue())) continue;
                        return featureAttributeDescriptor.getLabel();
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Fail", (Throwable)ex);
                this.availableValues.put(fieldName, INVALID_AVAILABLE_VALUES);
            }
        }
        return Objects.toString(value);
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        try {
            Object value;
            Feature feature = (Feature)this.features.get64(this.index);
            if (fieldName.startsWith("COLUMN_")) {
                value = feature.get(Integer.parseInt(fieldName.substring(7)));
            } else if (fieldName.endsWith("@label")) {
                fieldName = StringUtils.removeEnd((String)fieldName, (String)"@label");
                value = this.getLabel(feature, fieldName);
            } else {
                value = feature.get(fieldName);
            }
            if (jrField.getValueClass() != null && !jrField.getValueClass().isInstance(value)) {
                Coercion coercion = this.coercions.get(fieldName);
                if (coercion == null) {
                    DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
                    DataType dataType = dataTypesManager.getDataType(jrField.getValueClass());
                    coercion = dataType == null ? new DummyCoercion() : dataType.getCoercion();
                    this.coercions.put(fieldName, coercion);
                }
                try {
                    value = coercion.coerce(value);
                }
                catch (CoercionException coercionException) {
                    // empty catch block
                }
            }
            return value;
        }
        catch (Exception ex) {
            if (CustomExpression.class.isAssignableFrom(jrField.getValueClass())) {
                return null;
            }
            throw new JRException("data.table.model.unknown.column.name", new Object[]{fieldName}, (Throwable)ex);
        }
    }

    public void moveFirst() throws JRException {
        this.index = -1L;
    }

    public long size64() {
        return this.features.size64();
    }

    public int size() {
        long sz = this.features.size64();
        if (sz > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sz;
    }

    public Feature get(int position) {
        return (Feature)this.features.get64((long)position);
    }

    public Feature get64(long position) {
        return (Feature)this.features.get64(position);
    }

    public JsonData subDataSource() throws JRException {
        return new JRFeatureStoreDataSource(this.context, this.features, this.storesRepository, this.featureType);
    }

    public JsonData subDataSource(String selectExpression) throws JRException {
        String storeName;
        int n;
        LOGGER.info("DataSurce(" + this.name + ").subDataSource(" + Objects.toString(selectExpression, "null") + ").");
        if (StringUtils.isBlank((CharSequence)selectExpression)) {
            return new JREmptyJSonData(1, this.storesRepository);
        }
        Expression filter = null;
        if ((selectExpression = selectExpression.trim()).toUpperCase().startsWith("SELECT ")) {
            if ((selectExpression = selectExpression.substring(7).trim()).startsWith("* ")) {
                selectExpression = selectExpression.substring(2).trim();
            }
            if (selectExpression.toUpperCase().startsWith("FROM ")) {
                selectExpression = selectExpression.substring(5).trim();
            }
        }
        if ((n = selectExpression.indexOf(" WHERE ")) < 0) {
            storeName = selectExpression.trim();
        } else {
            storeName = selectExpression.substring(0, n).trim();
            filter = ExpressionUtils.createExpression((String)selectExpression.substring(n + 6).trim());
        }
        if (this.storesRepository.get((Object)storeName) == null) {
            return new JREmptyJSonData(1, this.storesRepository);
        }
        JRFeatureStoreDataSource x = new JRFeatureStoreDataSource(this.context, (FeatureStore)this.storesRepository.getStore(storeName), filter);
        return x;
    }

    public Feature getCurrentFeature() {
        try {
            Feature feature = (Feature)this.features.get64(this.index);
            return feature;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public FeatureSymbolTable getFeatureSymbolTable() {
        if (this.featureSymbolTable == null) {
            this.featureSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
        }
        Feature feature = this.getCurrentFeature();
        this.featureSymbolTable.setFeature(feature);
        return this.featureSymbolTable;
    }

    private static class DummyCoercion
    implements Coercion {
        private DummyCoercion() {
        }

        public Object coerce(Object o) throws CoercionException {
            return o;
        }

        public Object coerce(Object value, CoercionContext context) throws CoercionException {
            return value;
        }
    }

    private class JREmptyJSonData
    extends JREmptyDataSource
    implements JsonData {
        JREmptyJSonData(int rows, StoresRepository storesRepository) {
            super(rows);
        }

        public JsonData subDataSource() throws JRException {
            return JRFeatureStoreDataSource.this.subDataSource();
        }

        public JsonData subDataSource(String selectExpression) throws JRException {
            LOGGER.info("DataSurce(<Empty>) subDataSource(" + Objects.toString(selectExpression, "null") + ")");
            return JRFeatureStoreDataSource.this.subDataSource(selectExpression);
        }
    }
}

