/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;

public class ReportExpressionCodeFormatter
implements Formatter<Code> {
    private final Formatter<Code>[] formatters;
    private final FeatureType featureType;

    public ReportExpressionCodeFormatter(FeatureType featureType) {
        this.featureType = featureType;
        this.formatters = new Formatter[]{new IdentifierQuotesFormatter(), new ReportValueFormatter()};
    }

    public boolean canApply(Code code) {
        for (Formatter<Code> formatter : this.formatters) {
            if (!formatter.canApply((Object)code)) continue;
            return true;
        }
        return false;
    }

    public String format(Code code) {
        for (Formatter<Code> formatter : this.formatters) {
            if (!formatter.canApply((Object)code)) continue;
            return formatter.format((Object)code);
        }
        return code.toString();
    }

    public class ReportValueFormatter
    implements Formatter<Code> {
        public boolean canApply(Code value) {
            Codes args;
            String name;
            return value instanceof Code.Callable && StringUtils.equals((CharSequence)(name = ((Code.Callable)value).name()), (CharSequence)"REPORT_VALUE") && (args = ((Code.Callable)value).parameters()).get(0) instanceof Code.Constant && ((Code.Constant)args.get(0)).value() instanceof String;
        }

        public String format(Code value) {
            Codes args = ((Code.Callable)value).parameters();
            String fieldName = ((Code.Constant)args.get(0)).value().toString();
            FeatureAttributeDescriptor attrdesc = ReportExpressionCodeFormatter.this.featureType.getAttributeDescriptor(fieldName);
            switch (attrdesc.getType()) {
                case 8: {
                    return "'\"+$F{" + fieldName + "}+\"'";
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return "\"+$F{" + fieldName + "}+\"";
                }
            }
            return "'\"+$F{" + fieldName + "}+\"'";
        }
    }

    public class IdentifierQuotesFormatter
    implements Formatter<Code> {
        public boolean canApply(Code code) {
            return code instanceof Code.Identifier;
        }

        public String format(Code code) {
            return "[" + ((Code.Identifier)code).name() + "]";
        }
    }
}

