/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.swing.impl.bean.combotext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.raster.swing.listener.PanelChangeEvent;
import org.gvsig.raster.swing.listener.PanelChangeListener;

public class ComboTextImpl
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JComboBox combo = null;
    private JTextField jtext = null;
    private JLabel label = null;
    private String boxLabel = null;
    private boolean borderEnabled = false;
    private boolean labelsEnabled = false;
    private PanelChangeListener listener = null;

    public ComboTextImpl(String[] labels, boolean border, boolean labelEnabled) {
        if (labels != null) {
            this.label = new JLabel(labels[0]);
            this.boxLabel = labels[1];
        }
        this.borderEnabled = border;
        this.labelsEnabled = labelEnabled;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        if (this.borderEnabled) {
            this.setBorder(BorderFactory.createTitledBorder(this.boxLabel));
        }
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        int x = 0;
        if (this.labelsEnabled) {
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.gridx = x++;
            this.add((Component)this.label, gridBagConstraints1);
        }
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridx = x++;
        this.add((Component)this.getCombo(), gridBagConstraints1);
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints1.gridx = x;
        this.add((Component)this.getTextField(), gridBagConstraints1);
    }

    public JComboBox getCombo() {
        if (this.combo == null) {
            this.combo = new JComboBox();
            this.combo.addActionListener(this);
        }
        return this.combo;
    }

    public JTextField getTextField() {
        if (this.jtext == null) {
            this.jtext = new JTextField();
            this.jtext.addActionListener(this);
            this.jtext.setEditable(true);
            this.jtext.setPreferredSize(new Dimension(60, 24));
            this.jtext.setSize(new Dimension(60, 24));
            this.jtext.setMinimumSize(new Dimension(60, 24));
            this.jtext.setMaximumSize(new Dimension(60, 24));
        }
        return this.jtext;
    }

    public void addPanelChangeEvent(PanelChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.getTextField().setEnabled(enable);
        this.getCombo().setEnabled(enable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener != null) {
            this.listener.panelHasChanged(new PanelChangeEvent((Object)e));
        }
    }
}

